#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_table_type_cmd_result, parse_data
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 逻辑端口信息
    :param context: 上下文数据
    """
    data_header = ["ID", "Zone ID", "Node ID", "Name", "RunningStatus", "Description", "External Dynamic IP",
                   "External IP"]
    parse_data(context, [data_header], get_logic_port_content)


def get_logic_port_content(context):
    logic_port_lines = get_command_result_lines(context, "cmd_display_info_equalizer_node_info")
    logic_port_dict_list = parse_table_type_cmd_result(logic_port_lines)
    return [
        [port.get("ID"), port.get("Zone ID"), port.get("Node ID"), port.get("Name"), port.get("RunningStatus"),
         port.get("Description"), port.get("External Dynamic IP"), port.get("External IP")]
        for port in logic_port_dict_list]
