#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 NFS Server信息
    :param context: 上下文数据
    """
    data_header = ["NFSv4 Domain Name"]
    parse_data(context, [data_header], get_nfs_server_content)


def get_nfs_server_content(context):
    nfs_share_lines = get_command_result_lines(context, "cmd_display_nfs_domain_name")
    for nfs_share_line in nfs_share_lines:
        if nfs_share_line.startswith("Domain") or nfs_share_line.startswith("domain"):
            domain_list = nfs_share_line.split("=")
            if len(domain_list) == 2:
                return [[domain_list[1].strip()]]
    return [[""]]
