#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import copy

from storages.HUAWEI.nas.util.parse_common import parse_data, parse_table_type_cmd_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 NFS共享信息
    :param context: 上下文数据
    """
    data_header = ["ID", "Share Name", "Description", "Share Path", "Lock Type", "Character Encode",
                   "Access Name", "AccessVal", "Sync", "AllSquash", "RootSquash"]
    parse_data(context, [data_header], get_nfs_share_content)


def get_nfs_share_content(context):
    data_content = []
    nfs_share_auth_lines = get_command_result_lines(context, "cmd_display_directory_share_nfs_auth_client_all_info")
    nfs_share_auth_dict_list = parse_table_type_cmd_result(nfs_share_auth_lines)
    mapping = build_nfs_client_all_share_path_mapping(nfs_share_auth_dict_list)
    nfs_share_lines = get_command_result_lines(context, "cmd_display_directory_share_nfs_all_info")
    nfs_share_dict_list = parse_table_type_cmd_result(nfs_share_lines)
    build_nfs_data_content(nfs_share_dict_list, mapping, data_content)
    return data_content


def build_nfs_data_content(nfs_share_dict_list, mapping, data_content):
    for nfs_share in nfs_share_dict_list:
        nfs_share_content = build_nfs_share_content(nfs_share)
        share_path = nfs_share.get("Share Path")
        if mapping.get(share_path):
            for data in mapping.get(share_path):
                new_nfs_share_content = copy.deepcopy(nfs_share_content)
                new_nfs_share_content.extend(data)
                data_content.append(new_nfs_share_content)
        else:
            nfs_share_content.extend([" ", " ", " ", " ", " "])
            data_content.append(nfs_share_content)


def build_nfs_share_content(nfs_share):
    return [nfs_share.get("ID"), nfs_share.get("Name"), nfs_share.get("Description"), nfs_share.get("Share Path"),
            nfs_share.get("Lock Type"), nfs_share.get("Character Encode")]


def build_nfs_client_all_share_path_mapping(nfs_share_auth_dict_list):
    nfs_share_auth_dict = {}
    for data in nfs_share_auth_dict_list:
        share_path = data.get("SharePath")
        nfs_auth_client = nfs_share_auth_dict.get(share_path, [])
        nfs_auth_client.append([data.get("Name"), data.get("AccessVal"), data.get("Sync"), data.get("AllSquash"),
                                data.get("RootSquash")])
        nfs_share_auth_dict[share_path] = nfs_auth_client
    return nfs_share_auth_dict
