#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, get_table_type_result


def execute(context):
    """
    获取 9000 node信息
    :param context: 上下文数据
    """
    data_header = ["ID", "Name", "Health Status", "Running Status", "Function Type"]
    parse_data(context, [data_header], get_node_content)


def get_node_content(context):
    key_name = ["ID", "Name", "Health Status", "Running Status", "Function Type"]
    node_data = get_table_type_result(context, "cmd_display_node_general_info")

    return [[node.get(key) for key in key_name] for node in node_data]
