#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_result


def execute(context):
    """
    获取9000 系统总览信息
    :param context: 上下文数据
    """
    data_header = ["DataCenter", "System Name", "Type", "Vendor", "Model", "Engine", "IP", "Product Name", "Version",
                   "Patch Version", "Health Status", "Running Status", "BusinessType", "Capacity", "Used Capacity",
                   "Predicted Available Capacity", "Redundance Data Count"]
    parse_data(context, [data_header], get_overview_content)


def get_overview_content(context):
    dev_type = context.get("dev_type")
    dev_vendor = context.get("dev_vendor")
    dev_model = context.get("dev_model")
    dev_ip = context.get("ip")
    system = get_key_value_type_result(context, "cmd_display_system_general_info", ":")
    return [[system.get("Cluster_ID"), system.get("Cluster_Name"), dev_type, dev_vendor, dev_model, "Engine",
             dev_ip, system.get("Cluster_ProductName"), system.get("Cluster_Version"),
             system.get("Cluster_Patch_Version"), system.get("Cluster_Health_Status"),
             system.get("Cluster_Running_Status"), system.get("Cluster_BusinessType"), system.get("Cluster_Capacity"),
             system.get("Cluster_Used_Capacity"), system.get("Cluster_Predicted_Available_Capacity"),
             parse_redundance_data_count(system)]]


def parse_redundance_data_count(system):
    """
    在部分存储上Cluster_Redundance_Data_Count的最后三个单词是大写的，此处需要适配
    """
    redundance_data_count = system.get("Cluster_Redundance_Data_Count")
    if not redundance_data_count:
        redundance_data_count = system.get("Cluster_REDUNDANCE_DATA_COUNT")
    return redundance_data_count
