#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, grouping_list_by_predicate, parse_table_type_cmd_result, \
    parse_key_value_type_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 文件系统quota信息
    :param context: 上下文数据
    """
    data_header = ["Quota_Dir_PATH", "Name", "Quota_Dir_STATUS", "path", "quota_normal_id", "create_type",
                   "template id", "resource_type", "hard_threshold", "soft_threshold", "advise_threshold",
                   "amount_used", "soft_threshold_extend_time", "quota_type", "user_or_group_name", "user_type",
                   "domain_type", "associate_template_group_name"]
    parse_data(context, [data_header], get_quota_content)


def get_quota_content(context):
    quota_path_lines = get_command_result_lines(context, "cmd_display_quota_all_path_info")
    quota_path_dict_list = parse_table_type_cmd_result(quota_path_lines)
    quota_path_status_dict = {path["Quota_Dir_PATH"]: path["Quota_Dir_STATUS"] for path in quota_path_dict_list}
    quota_normal_lines = get_command_result_lines(context, "cmd_display_quota_normal_info")
    quota_groups = grouping_list_by_predicate(quota_normal_lines, lambda line: line.strip().startswith("----"))
    return [get_row_data(quota, quota_path_status_dict) for quota in quota_groups]


def get_row_data(quota, quota_path_status_dict):
    quota_dict = parse_key_value_type_result(quota, ":")
    quota_dir_path = quota_dict.get("path")
    name = quota_dict.get("path")
    quota_dir_status = quota_path_status_dict.get(quota_dir_path)
    path = quota_dict.get("path")
    quota_normal_id = quota_dict.get("id")
    create_type = quota_dict.get("create_type")
    template_id = quota_dict.get("template_id")
    resource_type = quota_dict.get("resource_type")
    hard_threshold = quota_dict.get("hard_threshold")
    soft_threshold = quota_dict.get("soft_threshold")
    advise_threshold = quota_dict.get("advise_threshold")
    amount_used = quota_dict.get("amount_used")
    soft_threshold_extend_time = quota_dict.get("soft_threshold_extend_time")
    quota_type = quota_dict.get("quota_type")
    user_or_group_name = quota_dict.get("user_or_group_name")
    user_type = quota_dict.get("user_type")
    domain_type = quota_dict.get("domain_type")
    associate_template_group_name = quota_dict.get("associate_template_group_name")
    return [quota_dir_path, name, quota_dir_status, path, quota_normal_id, create_type, template_id,
            resource_type, hard_threshold, soft_threshold, advise_threshold, amount_used,
            soft_threshold_extend_time, quota_type, user_or_group_name, user_type, domain_type,
            associate_template_group_name]
