#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, parse_table_type_cmd_result, grouping_list_by_predicate, \
    parse_key_value_type_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 文件系统quota_template信息
    :param context: 上下文数据
    """
    data_header = ["Quota_Dir_PATH", "Name", "Quota_Dir_STATUS", "path", "template id", "resource_type",
                   "hard_threshold", "soft_threshold", "advise_threshold", "soft_threshold_extend_time", "quota_type",
                   "user_or_group_name"]
    parse_data(context, [data_header], get_quota_template_content)


def get_quota_template_content(context):
    quota_path_lines = get_command_result_lines(context, "cmd_display_quota_all_path_info")
    quota_path_dict_list = parse_table_type_cmd_result(quota_path_lines)
    quota_path_status_dict = {path["Quota_Dir_PATH"]: path["Quota_Dir_STATUS"] for path in quota_path_dict_list}
    template_lines = get_command_result_lines(context, "cmd_display_quota_template_info")
    template_groups = grouping_list_by_predicate(template_lines, lambda line: line.strip().startswith("----"))
    return [get_row_data(quota_path_status_dict, quota_template) for quota_template in template_groups]


def get_row_data(quota_path_status_dict, quota_template):
    quota_template_dict = parse_key_value_type_result(quota_template, ":")
    quota_dir_path = quota_template_dict.get("path")
    name = quota_template_dict.get("path")
    quota_dir_status = quota_path_status_dict.get(quota_dir_path)
    path = quota_template_dict.get("path")
    template_id = quota_template_dict.get("id")
    resource_type = quota_template_dict.get("resource_type")
    hard_threshold = quota_template_dict.get("hard_threshold")
    soft_threshold = quota_template_dict.get("soft_threshold")
    advise_threshold = quota_template_dict.get("advise_threshold")
    soft_threshold_extend_time = quota_template_dict.get("soft_threshold_extend_time")
    quota_type = quota_template_dict.get("quota_type")
    user_or_group_name = quota_template_dict.get("user_or_group_name")
    return [quota_dir_path, name, quota_dir_status, path, template_id, resource_type, hard_threshold,
            soft_threshold, advise_threshold, soft_threshold_extend_time, quota_type, user_or_group_name]
