#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, parse_table_type_cmd_result, get_key_value_type_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 用户远程复制信息
    :param context: 上下文数据
    """
    data_header = ["LocalResourceName", "RemoteResourceName", "HealthStatus", "RunningStatus", "IsPrimary", "TargetIp"]
    parse_data(context, [data_header], get_remote_replication_content)


def get_remote_replication_content(context):
    remote_replication_lines = get_command_result_lines(context, "cmd_display_remote_replication_general_info")
    remote_replication_dict_list = parse_table_type_cmd_result(remote_replication_lines)
    channel_lines = get_command_result_lines(context, "cmd_display_remote_replication_channel_info")
    channel_dict_list = parse_table_type_cmd_result(channel_lines)
    channel_id_ip_dict = {channel["ID"]: channel["TargetIp"] for channel in channel_dict_list}
    return [
        [replication.get("LocalResourceName"), replication.get("RemoteResourceName"), replication.get("HealthStatus"),
         replication.get("RunningStatus"),
         get_remote_replication_general_info(context, replication.get("ID")).get("IsPrimary"),
         channel_id_ip_dict.get(replication.get("ChannelId"))]
        for replication in remote_replication_dict_list]


def get_remote_replication_general_info(context, pair_id):
    description = "cmd_display_remote_replication_general_info_with_pair_id_%s" % pair_id
    return get_key_value_type_result(context, description, ":")
