#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, grouping_list_by_predicate, parse_key_value_type_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 快照信息
    :param context: 上下文数据
    """
    data_header = ["ID", "Name", "Directory Path", "Snapshot Frequency", "Week Days", "Day Hours", "Day Minute",
                   "Month Days", "Snapshot Expiration"]
    parse_data(context, [data_header], get_snapshot_content)


def get_snapshot_content(context):
    snapshot_schedule_lines = get_command_result_lines(context, "cmd_display_snapshot_schedule_info")
    snapshot_schedule_groups = grouping_list_by_predicate(snapshot_schedule_lines,
                                                          lambda line: line.strip().startswith("----"))
    data_content = []
    for snapshot_schedule in snapshot_schedule_groups:
        snapshot_dict = parse_key_value_type_result(snapshot_schedule, ":")
        snapshot_id = snapshot_dict.get("ID")
        name = snapshot_dict.get("Name")
        path = snapshot_dict.get("Directory Path")
        snapshot_frequency = snapshot_dict.get("Snapshot Frequency")
        week_days = snapshot_dict.get("Week Days")
        day_hours = snapshot_dict.get("Day Hours")
        day_minute = snapshot_dict.get("Day Minute")
        month_days = snapshot_dict.get("Month Days")
        snapshot_expiration = snapshot_dict.get("Snapshot Expiration")
        row_data = [snapshot_id, name, path, snapshot_frequency, week_days, day_hours, day_minute,
                    month_days, snapshot_expiration]
        data_content.append(row_data)
    return data_content
