#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_result


def execute(context):
    """
    获取9000 用户映射配置信息
    :param context: 上下文数据
    """
    data_header = ["provider", "idmu_timeout", "idmu_base_dn", "idmu_win_objectclass", "idmu_unix_objectclass"]
    parse_data(context, [data_header], get_user_mapping_config_content)


def get_user_mapping_config_content(context):
    config = get_key_value_type_result(context, "cmd_display_identity_mapping_config_info", ":")
    return [[config.get("provider"), config.get("idmu_timeout"), config.get("idmu_base_dn"),
             config.get("idmu_win_objectclass"), config.get("idmu_unix_objectclass")]]
