#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, parse_table_type_cmd_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 用户映射信息
    :param context: 上下文数据
    """
    data_header = ["ID", "From Identity", "To Identity", "Mapping Type", "Priority"]
    parse_data(context, [data_header], get_user_mapping_content)


def get_user_mapping_content(context):
    user_mapping_lines = get_command_result_lines(context, "cmd_display_identity_mapping_rule_info")
    user_mapping_dict_list = parse_table_type_cmd_result(user_mapping_lines)
    return [
        [user_mapping.get("id"), user_mapping.get("from_identity"), user_mapping.get("to_identity"),
         user_mapping.get("mapping_type"), user_mapping.get("priority")]
        for user_mapping in user_mapping_dict_list]
