#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, parse_table_type_cmd_result, get_sid_from_lines
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 本地用户信息
    :param context: 上下文数据
    """
    data_header = ["User ID", "User Name", "Primary Group ID", "Primary Group Name", "Secondary Group Names",
                   "Group Names", "User Type", "Status Enabled", "PwdValidPeriod(days)", "Description", "SID Prefix",
                   "SID Suffix", "Type"]
    parse_data(context, [data_header], get_user_content)


def get_user_content(context):
    user_lines = get_command_result_lines(context, "cmd_display_local_user_all_info")
    user_dict_list = parse_table_type_cmd_result(user_lines)
    return [
        [user.get("ID"), user.get("Name"), user.get("PrimaryGroupId"), user.get("PrimaryGroupName"),
         user.get("GroupNames"), get_user_group_names(user), user.get("UserType"), user.get("StatusEnable"),
         user.get("PwdValidPeriod(days)"), user.get("Description"), get_user_sid(context, user)[0],
         get_user_sid(context, user)[1], "ALL"]
        for user in user_dict_list]


def get_user_group_names(user):
    primary_group_names = user.get("PrimaryGroupName")
    group_names = user.get("GroupNames")
    return primary_group_names + "," + group_names if group_names else primary_group_names


def get_user_sid(context, user):
    user_lines = get_command_result_lines(context, "cmd_display_user_sid_with_user_id_%s" % user.get("ID"))
    if "<sid>" not in user_lines:
        user_lines = get_command_result_lines(context, "cmd_display_user_sid_with_user_name_%s" % user.get("Name"))
    return get_sid_from_lines(user_lines)
