#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, parse_table_type_cmd_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取9000 WORM信息
    :param context: 上下文数据
    """
    data_header = ["ID", "File Path", "Worm Type", "Auto Delete", "Worm Min Protect Period", "Worm Max Protect Period",
                   "Worm Def Protect Period", "Worm Auto Lock Time", "Log Directory"]
    parse_data(context, [data_header], get_worm_dir_content)


def get_worm_dir_content(context):
    worm_dir_lines = get_command_result_lines(context, "cmd_display_worm_dir_all_info")
    worm_dir_dict_list = parse_table_type_cmd_result(worm_dir_lines)
    worm_logdir_lines = get_command_result_lines(context, "cmd_display_worm_logdir_info")
    log_dir = ""
    if len(worm_logdir_lines) >= 5:
        log_dir = worm_logdir_lines[4].strip()
    return [
        [worm_dir.get("ID"), worm_dir.get("File Path"), worm_dir.get("Worm Type"), worm_dir.get("Auto Delete"),
         worm_dir.get("Worm Min Protect Period"), worm_dir.get("Worm Max Protect Period"),
         worm_dir.get("Worm Def Protect Period"), worm_dir.get("Worm Auto Lock Time"),
         get_log_dir(log_dir, worm_dir.get("File Path"))]
        for worm_dir in worm_dir_dict_list]


def get_log_dir(log_dir, current_dir):
    return "Yes" if log_dir == current_dir else "--"
