#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo

ADMIN_CMDS = [
    {
        DES: "cmd_display_fs_clone_file_system_id=%s",
        CMD: "show fs_clone general file_system_id=%s",
    },
]

DEVELOPER_CMDS = [
    {
        DES: "cmd_display_fs_clone_split_file_system_id=%s",
        CMD: "show fs_clone split file_system_id=%s",
    },
]


class HuaweiV3V5FilesystemCloneInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5FilesystemCloneInfo, self).__init__(context)

    def execute(self):
        result = self.exec_cmd("show file_system general")
        table_data = parse_table_type_result(result.splitlines())
        curr_step = 5
        each_step_width = 40 / len(table_data) if table_data else 40
        for data in table_data:
            file_system_id = data.get("ID")
            self.execute_cmds_with_params(ADMIN_CMDS, (file_system_id,), (file_system_id,), curr_step, each_step_width)
        self.change_to_developer()
        each_step_width = 45 / len(table_data) if table_data else 45
        for data in table_data:
            file_system_id = data.get("ID")
            self.execute_cmds_with_params(DEVELOPER_CMDS, (file_system_id,), (file_system_id,), curr_step,
                                          each_step_width)
        self.exit_developer()
