#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo

ADMIN_CMD = [
    {DES: "cmd_display_ndmp_tape_service_info", CMD: "show service ndmp_tape"},
    {DES: "cmd_display_admin_ndmp_service_info", CMD: "show service ndmp"},
]

VSTORE_CMDS = [
    {DES: "cmd_display_vstore_%s_ndmp_service_info", CMD: "show service ndmp"},
]


class HuaweiV3V5NdmpServiceInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5NdmpServiceInfo, self).__init__(context)

    def execute(self):
        self.execute_cmds_without_params(ADMIN_CMD, 5, 20, False)
        self.execute_vstore_cmd_without_detail(VSTORE_CMDS, 25, 65, False, True)
