#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo

# Excel-Cifs_Server
ADMIN_CMDS = [
    {DES: "cmd_display_admin_cifs_common_config", CMD: "show common_config cifs"},
    {DES: "cmd_display_admin_sid_mapping_config", CMD: "show sid_mapping_config"},
    {DES: "cmd_display_admin_sid_mapping_rule", CMD: "show sid_mapping_rule general"},
    {DES: "cmd_display_admin_fs_security", CMD: "show fs_security config"},
]

DEVELOPER_CMDS = [
    {DES: "cmd_display_admin_cifs_service", CMD: "show service cifs"},
    {DES: "cmd_display_admin_cifs_service_config", CMD: "show service cifs_config"},
    {DES: "cmd_display_admin_cifs_reserve_bit", CMD: "show cifs reserve_bit"},
    # 默认租户信息
    {DES: "cmd_display_admin_cifs_reserve_bit_tenantid_equals_0", CMD: "show cifs reserve_bit tenantid=0"},
]

VSTORE_CMDS = [
    {DES: "cmd_display_vstore_%s_cifs_service", CMD: "show service cifs", },
    {DES: "cmd_display_vstore_%s_cifs_service_config", CMD: "show service cifs_config", },
    {DES: "cmd_display_vstore_%s_sid_mapping_config", CMD: "show sid_mapping_config", },
    {DES: "cmd_display_vstore_%s_sid_mapping_rule", CMD: "show sid_mapping_rule general", },
    {DES: "cmd_display_vstore_%s_fs_security", CMD: "show fs_security config", },
]


class HuaweiV3V5CifsServiceConfInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5CifsServiceConfInfo, self).__init__(context)

    def execute(self):
        self.execute_cmds_without_params(ADMIN_CMDS, 5, 10, False)
        self.execute_cmds_without_params(DEVELOPER_CMDS, 15, 20, True)
        self.execute_special_cmd_in_admin_dev_mode()
        self.execute_vstore_cmd_without_detail(VSTORE_CMDS, 45, 45, False, True)

    def execute_special_cmd_in_admin_dev_mode(self):
        """
        在默认租户开发者模式下执行特殊命令
        """
        vstores = self.get_vstore()
        curr_step = 35
        progress_width = 10 / len(vstores) if vstores else 10
        commands = []
        self.change_to_developer()
        for vstore_id in vstores.values():
            # 这里是特殊场景，tenantid就是租户id 默认租户id为0
            commands.append({DES: "cmd_display_vstore_%s_cifs_reserve_bit" % vstore_id,
                             CMD: "show cifs reserve_bit tenantid=%s" % vstore_id})
        self.execute_pure_cmd_list(commands=commands, cur_step=curr_step, progress_width=progress_width)
        self.exit_developer()
