#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo, DETAIL_CMD, DETAIL_DES, DETAIL_ID_KEY

# Excel-CIFS_Share
# 默认租户admin nfs共享配置,默认租户可能名称不为admin
ADMIN_CMDS_WITH_DETAIL = [
    {
        DES: "cmd_display_admin_cifs_share",
        CMD: "show share cifs",
        DETAIL_DES: "cmd_display_admin_cifs_share_id_%s",
        DETAIL_CMD: "show share cifs share_id=%s",
        DETAIL_ID_KEY: "Share ID",
    },
    {
        DES: "cmd_display_admin_cifs_share_type_all",
        CMD: "show share cifs share_type=all",
        DETAIL_DES: "cmd_display_admin_cifs_all_share_id_%s",
        DETAIL_CMD: "show share cifs share_id=%s",
        DETAIL_ID_KEY: "Share ID",
    },
    {
        DES: "cmd_display_admin_cifs_share_type_normal",
        CMD: "show share cifs share_type=normal",
        DETAIL_DES: "cmd_display_admin_cifs_normal_share_id_%s",
        DETAIL_CMD: "show share cifs share_id=%s",
        DETAIL_ID_KEY: "Share ID",
    },
    {
        DES: "cmd_display_admin_cifs_share_type_homedir",
        CMD: "show share cifs share_type=homedir",
        DETAIL_DES: "cmd_display_admin_cifs_homedir_share_id_%s",
        DETAIL_CMD: "show share cifs share_id=%s",
        DETAIL_ID_KEY: "Share ID",
    },
]

ADMIN_CMD = [
    {
        DES: "cmd_display_admin_cifs_share_permission",
        CMD: "show share_permission cifs",
    },
    {
        DES: "cmd_display_admin_cifs_share_ip_control",
        CMD: "show share_ip_control cifs",
    },
    {
        DES: "cmd_display_admin_cifs_file_extension_filter",
        CMD: "show file_extension_filter cifs",
    },
    {
        DES: "cmd_display_admin_cifs_share_homedir_rule",
        CMD: "show share_homedir_rule cifs",
    },
]

VSTORE_CMDS_WITH_DETAIL = [
    {
        DES: "cmd_display_vstore_%s_cifs_share",
        CMD: "show share cifs share_type=all",
        DETAIL_DES: "cmd_display_vstore_%s_cifs_share_id_%s",
        DETAIL_CMD: "show share cifs share_id=%s",
        DETAIL_ID_KEY: "Share ID",
    },
    {
        DES: "cmd_display_vstore_%s_cifs_share_type_normal",
        CMD: "show share cifs share_type=normal",
        DETAIL_DES: "cmd_display_vstore_%s_cifs_normal_share_id_%s",
        DETAIL_CMD: "show share cifs share_id=%s",
        DETAIL_ID_KEY: "Share ID",
    },
    {
        DES: "cmd_display_vstore_%s_cifs_share_type_homedir",
        CMD: "show share cifs share_type=homedir",
        DETAIL_DES: "cmd_display_vstore_%s_cifs_homedir_share_id_%s",
        DETAIL_CMD: "show share cifs share_id=%s",
        DETAIL_ID_KEY: "Share ID",
    },
]

VSTORE_CMD = [
    {
        DES: "cmd_display_vstore_%s_cifs_share_permission",
        CMD: "show share_permission cifs",
    },
    {
        DES: "cmd_display_vstore_%s_cifs_share_ip_control",
        CMD: "show share_ip_control cifs",
    },
    {
        DES: "cmd_display_vstore_%s_cifs_file_extension_filter",
        CMD: "show file_extension_filter cifs",
    },
    {
        DES: "cmd_display_vstore_%s_cifs_share_homedir_rule",
        CMD: "show share_homedir_rule cifs",
    },
]


class HuaweiV3V5CifsShareInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5CifsShareInfo, self).__init__(context)

    def execute(self):
        # 默认租户执行命令
        self.execute_admin_cmd_with_detail(ADMIN_CMDS_WITH_DETAIL, 5, 20, True)
        self.execute_cmds_without_params(ADMIN_CMD, 25, 15, False)
        # 其它租户执行命令
        self.execute_vstore_cmd_with_detail(VSTORE_CMDS_WITH_DETAIL, 40, 20, True)
        vstores = self.get_vstore()
        for vstore_id in vstores.values():
            self.change_vstore(vstore_id)
            self.execute_cmds_with_params(VSTORE_CMD, (vstore_id,), None, 60, 30)
            self.exit_to_admin()
