#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo

# Excel-Domains
ADMIN_CMDS = [
    {DES: "cmd_display_admin_domain_dns_info", CMD: "show domain dns"},
    {DES: "cmd_display_admin_domain_ad_info", CMD: "show domain ad"},
    {DES: "cmd_display_admin_domain_ad_prefdc", CMD: "show domain ad_prefdc"},
    {DES: "cmd_display_admin_domain_ldap_info", CMD: "show domain ldap"},
    {DES: "cmd_display_admin_domain_ldap_schema", CMD: "show domain ldap_schema"},
    {DES: "cmd_display_admin_domain_nis_info", CMD: "show domain nis"},
    {DES: "cmd_display_admin_domain_dns_zone_general", CMD: "show dns_zone general"},
]

VSTORE_CMDS = [
    {DES: "cmd_display_vstore_%s_domain_dns_info", CMD: "show domain dns"},
    {DES: "cmd_display_vstore_%s_domain_ad_info", CMD: "show domain ad"},
    {DES: "cmd_display_vstore_%s_domain_ad_prefdc", CMD: "show domain ad_prefdc"},
    {DES: "cmd_display_vstore_%s_domain_ldap_info", CMD: "show domain ldap"},
    {DES: "cmd_display_vstore_%s_domain_ldap_schema", CMD: "show domain ldap_schema"},
    {DES: "cmd_display_vstore_%s_domain_nis_info", CMD: "show domain nis"},
]


class HuaweiV3V5DomainInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5DomainInfo, self).__init__(context)

    def execute(self):
        self.execute_cmds_without_params(ADMIN_CMDS, 5, 30, False)
        self.execute_vstore_cmd_without_detail(VSTORE_CMDS, 35, 55, False, False)
