#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo

BASIC_CMDS = [
    {DES: "cmd_display_admin_file_system_general", CMD: "show file_system general"},
]

ADMIN_CMDS = [
    {
        DES: "cmd_display_vstore_%s_file_system_id=%s",
        CMD: "show file_system general file_system_id=%s",
    },

]

VSTORE_FILE_SYSTEM_ANALYSIS_CMDS = [
    {
        DES: "cmd_display_vstore_%s_file_analysis_file_system_id=%s",
        CMD: "show file_system_analysis file_system_id=%s",
    },
]


class HuaweiV3V5FileSystemInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5FileSystemInfo, self).__init__(context)

    def execute(self):
        self.execute_cmds_without_params(BASIC_CMDS, 5, 10, False)
        self.execute_admin_cmd()
        self.execute_file_system_analysis_cmd()

    def execute_admin_cmd(self):
        data_dict = self.get_vstore_id_file_system_ids_mapping()
        for vstore_id, file_system_ids in data_dict.items():
            for file_system_id in file_system_ids:
                self.execute_cmds_with_params(ADMIN_CMDS, (vstore_id, file_system_id), (file_system_id,), 15, 60)

    def execute_file_system_analysis_cmd(self):
        data_dict = self.get_vstore_id_file_system_ids_mapping()
        curr_step = 75
        each_step_width = 15 / len(data_dict) if data_dict else 15
        for vstore_id, file_system_ids in data_dict.items():
            for file_system_id in file_system_ids:
                if vstore_id == "--":
                    self.execute_cmds_with_params(VSTORE_FILE_SYSTEM_ANALYSIS_CMDS, (vstore_id, file_system_id),
                                                  (file_system_id,), curr_step, each_step_width)
                else:
                    self.change_vstore(vstore_id)
                    self.execute_cmds_with_params(VSTORE_FILE_SYSTEM_ANALYSIS_CMDS, (vstore_id, file_system_id),
                                                  (file_system_id,), curr_step, each_step_width)
                    self.exit_to_admin()

    def get_vstore_id_file_system_ids_mapping(self):
        result = self.exec_cmd("show file_system general")
        table_data = parse_table_type_result(result.splitlines())
        data_dict = {}
        for data in table_data:
            vstore_id = data.get("Vstore ID")
            file_system_ids = data_dict.get(vstore_id, [])
            file_system_ids.append(data.get("ID"))
            data_dict[vstore_id] = file_system_ids
        return data_dict
