#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo

# Excel-Group
ADMIN_CMDS = [
    {
        DES: "cmd_display_admin_resource_group_group_id_%s",
        CMD: "show resource_group general group_id=%s",
    },
    {
        DES: "cmd_display_admin_resource_group_ad_group_group_id_%s",
        CMD: "show resource_group ad_group group_id=%s",
    },
    {
        DES: "cmd_display_admin_resource_group_ad_user_group_id_%s",
        CMD: "show resource_group ad_user group_id=%s",
    },
]

VSTORE_CMDS = [
    {
        DES: "cmd_display_vstore_%s_resource_group_group_id_%s",
        CMD: "show resource_group general group_id=%s",
    },
    {
        DES: "cmd_display_vstore_%s_resource_group_ad_group_group_id_%s",
        CMD: "show resource_group ad_group group_id=%s",
    },
    {
        DES: "cmd_display_vstore_%s_resource_group_ad_user_group_id_%s",
        CMD: "show resource_group ad_user group_id=%s",
    },
]


class HuaweiV3V5GroupInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5GroupInfo, self).__init__(context)

    def execute(self):
        self.exe_developer_admin_cmd()
        self.execute_developer_vstore_cmd()

    def exe_developer_admin_cmd(self):
        content = self.execute_cmd_and_put_result("cmd_display_admin_resource_group",
                                                  "show resource_group general")
        self.update_progress(5, 10)
        resource_group_ids = self.get_cmd_specific_column_info(content, "Resource Group ID")
        curr_step = 15
        each_step = 30 / len(resource_group_ids) if resource_group_ids else 30
        self.change_to_developer()
        for group_id in resource_group_ids:
            self.execute_cmds_with_params(ADMIN_CMDS, (group_id,), (group_id,), curr_step, each_step)
        self.exit_developer()

    def execute_developer_vstore_cmd(self):
        vstores = self.get_vstore()
        curr_step = 45
        each_step = 45 / len(vstores) if vstores else 45
        for vstore_id in vstores.values():
            self.change_vstore(vstore_id)
            self.change_to_developer()
            content = self.execute_cmd_and_put_result("cmd_display_vstore_%s_resource_group" % vstore_id,
                                                      "show resource_group general")
            resource_group_ids = self.get_cmd_specific_column_info(content, "Resource Group ID")
            for group_id in resource_group_ids:
                self.execute_cmds_with_params(VSTORE_CMDS, (vstore_id, group_id), (group_id,), curr_step, each_step)
            self.exit_developer()
            self.exit_to_admin()
