#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo, DETAIL_DES, DETAIL_CMD, DETAIL_ID_KEY

# Excel-Hyper_Metro
ADMIN_CMDS_WITH_DETAIL = [
    {
        DES: "cmd_display_admin_hyper_metro_pair_general",
        CMD: "show hyper_metro_pair general",
        DETAIL_DES: "cmd_display_admin_hyper_metro_pair_general_pair_id=%s",
        DETAIL_CMD: "show hyper_metro_pair general pair_id=%s",
        DETAIL_ID_KEY: "ID",
    },
]

ADMIN_CMD = [
    {DES: "cmd_display_admin_hyper_metro_vstore_pair_general", CMD: "show hyper_metro_vstore_pair general"},
    {DES: "cmd_display_admin_hyper_metro_domain_general", CMD: "show hyper_metro_domain general"},
    {DES: "cmd_display_admin_remote_device_general", CMD: "show remote_device general"},
]


class HuaweiV3V5HyperMetroInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5HyperMetroInfo, self).__init__(context)

    def execute(self):
        self.execute_each_cmd_with_detail(ADMIN_CMDS_WITH_DETAIL, 5, 55)
        self.execute_cmds_without_params(ADMIN_CMD, 60, 30, False)
