#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo

# Excel-Logical_Port
BASIC_CMDS = [
    {DES: "cmd_display_admin_logical_port", CMD: "show logical_port general"},
]

ADMIN_CMDS = [
    {
        DES: "cmd_display_vstore_%s_logical_port_name_%s",
        CMD: "show logical_port general logical_port_name=%s",
    },
]


class HuaweiV3V5LogicalPortInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5LogicalPortInfo, self).__init__(context)

    def execute(self):
        self.execute_cmds_without_params(BASIC_CMDS, 5, 10, False)
        self.execute_admin_cmd()

    def execute_admin_cmd(self):
        data_dict = self.get_vstore_id_logical_port_names_mapping()
        for vstore_id, logical_port_names in data_dict.items():
            for name in logical_port_names:
                self.execute_cmds_with_params(ADMIN_CMDS, (vstore_id, name), (name,), 15, 75)

    def get_vstore_id_logical_port_names_mapping(self):
        result = self.exec_cmd("show logical_port general")
        table_data = parse_table_type_result(result.splitlines())
        data_dict = {}
        for data in table_data:
            vstore_id = data.get("vStore ID")
            logical_port_names = data_dict.get(vstore_id, [])
            logical_port_names.append(data.get("Logical Port Name"))
            data_dict[vstore_id] = logical_port_names
        return data_dict
