#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo

# Excel-Nfs_Server
ADMIN_CMDS = [
    {DES: "cmd_display_admin_nfs_common_config", CMD: "show common_config nfs"},
    {DES: "cmd_display_admin_nfs_service", CMD: "show service nfs"},
]

DEVELOPER_CMDS = [
    {DES: "cmd_display_admin_nfs_service_config", CMD: "show service nfs_config"},
    {DES: "cmd_display_admin_nfs_reserve_bit", CMD: "show nfs reserve_bit"},
    {DES: "cmd_display_admin_nfs_long_filename_support", CMD: "show nfs long_filename_support"},
]

VSTORE_CMDS = [
    {DES: "cmd_display_vstore_%s_nfs_service", CMD: "show service nfs", },
    {DES: "cmd_display_vstore_%s_nfs_service_config", CMD: "show service nfs_config", },
]


class HuaweiV3V5NfsServerConfInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5NfsServerConfInfo, self).__init__(context)

    def execute(self):
        self.execute_cmds_without_params(ADMIN_CMDS, 5, 10, False)
        self.execute_cmds_without_params(DEVELOPER_CMDS, 15, 20, True)
        self.execute_vstore_cmd_without_detail(VSTORE_CMDS, 35, 55, False, True)

