#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo, DETAIL_CMD, DETAIL_DES, DETAIL_ID_KEY

# Excel-NFS_Share
# 默认租户admin nfs共享配置,默认租户可能名称不为admin
ADMIN_CMDS_WITH_DETAIL = [
    {
        DES: "cmd_display_admin_nfs_share",
        CMD: "show share nfs",
        DETAIL_DES: "cmd_display_admin_nfs_share_id_%s",
        DETAIL_CMD: "show share nfs share_id=%s",
        DETAIL_ID_KEY: "Share ID",
    },
    {
        DES: "cmd_display_admin_nfs_share_permission",
        CMD: "show share_permission nfs",
        DETAIL_DES: "cmd_display_admin_nfs_share_permission_id_%s",
        DETAIL_CMD: "show share_permission nfs share_permission_id=%s",
        DETAIL_ID_KEY: "Share Permission ID",
    },
]

VSTORE_CMDS_WITH_DETAIL = [
    {
        DES: "cmd_display_vstore_%s_nfs_share",
        CMD: "show share nfs",
        DETAIL_DES: "cmd_display_vstore_%s_nfs_share_id_%s",
        DETAIL_CMD: "show share nfs share_id=%s",
        DETAIL_ID_KEY: "Share ID",
    },
    {
        DES: "cmd_display_vstore_%s_nfs_share_permission",
        CMD: "show share_permission nfs",
        DETAIL_DES: "cmd_display_vstore_%s_nfs_share_permission_id_%s",
        DETAIL_CMD: "show share_permission nfs share_permission_id=%s",
        DETAIL_ID_KEY: "Share Permission ID",
    },
]


class HuaweiV3V5NfsShareInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5NfsShareInfo, self).__init__(context)

    def execute(self):
        # 执行这条命令必须是admin权限
        self.execute_admin_cmd_with_detail(ADMIN_CMDS_WITH_DETAIL, 5, 20, False, 300)
        self.execute_vstore_cmd_with_detail(VSTORE_CMDS_WITH_DETAIL, 25, 65, False, 300)
