#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo

# Excel-Quota
# 默认租户(admin)下有单独的文件系统，采集是admin下文件系统Vstore ID的值为"--"
ADMIN_CMDS_WITH_PARAMS = [
    {
        DES: "cmd_display_vstore_%s_quota_file_system_id=%s",
        CMD: "show quota general file_system_id=%s",
    },
    {
        DES: "cmd_display_vstore_%s_quota_tree_file_system_id=%s",
        CMD: "show quota_tree general file_system_id=%s",
    }
]


class HuaweiV3V5QuotaAndQtreeInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5QuotaAndQtreeInfo, self).__init__(context)

    def execute(self):
        result = self.exec_cmd("show file_system general")
        data = parse_table_type_result(result.splitlines())
        curr_step = 15
        each_step = 75 / len(data) if data else 75
        for row in data:
            file_sys_id = row.get("ID")
            vstore_id = row.get("Vstore ID")
            self.execute_cmds_with_params(ADMIN_CMDS_WITH_PARAMS, (vstore_id, file_sys_id), (file_sys_id,),
                                          curr_step, each_step)
