#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo, DETAIL_CMD, DETAIL_DES, DETAIL_ID_KEY

# Excel-Remote_Replication
ADMIN_CMDS_WITH_DETAIL = [
    {
        DES: "cmd_display_admin_remote_replication_unified",
        CMD: "show remote_replication unified list_type=fs",
        DETAIL_DES: "cmd_display_admin_remote_replication_unified_replication_id_%s",
        DETAIL_CMD: "show remote_replication unified remote_replication_id=%s",
        DETAIL_ID_KEY: "ID",
    },
    {
        DES: "cmd_display_admin_remote_replication_vstore_general",
        CMD: "show remote_replication_vstore general",
        DETAIL_DES: "cmd_display_admin_remote_replication_vstore_vstore_pair_%s",
        DETAIL_CMD: "show remote_replication_vstore general vstore_pair_id=%s",
        DETAIL_ID_KEY: "ID",
    },
]


class HuaweiV3V5RemoteReplicationInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5RemoteReplicationInfo, self).__init__(context)

    def execute(self):
        self.execute_admin_cmd_with_detail(ADMIN_CMDS_WITH_DETAIL, 5, 85, False)
