#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo, DETAIL_CMD, DETAIL_DES, DETAIL_ID_KEY

# Excel-Snapshot
ADMIN_CMDS_WITH_DETAIL = [
    {
        DES: "cmd_display_all_fs_snapshot_schedule",
        CMD: "show fs_snapshot schedule",
        DETAIL_DES: "cmd_display_each_fs_snapshot_schedule_schedule_id_%s",
        DETAIL_CMD: "show fs_snapshot schedule schedule_id=%s",
        DETAIL_ID_KEY: "ID",
    },
]

ADMIN_CMDS_WITH_PARAMS = [
    {
        DES: "cmd_display_vstore_%s_fs_snapshot_general_file_system_id=%s",
        CMD: "show fs_snapshot general file_system_id=%s",
    },
]


class HuaweiV3V5SnapshotInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5SnapshotInfo, self).__init__(context)

    def execute(self):
        # 执行这条命令必须是admin权限
        self.execute_admin_cmd_with_detail(ADMIN_CMDS_WITH_DETAIL, 5, 55, False)
        self.execute_admin_cmds_with_params()

    def execute_admin_cmds_with_params(self):
        result = self.exec_cmd("show file_system general")
        data = parse_table_type_result(result.splitlines())
        curr_step = 60
        each_step = 30 / len(data) if data else 30
        for row in data:
            file_sys_id = row.get("ID")
            vstore_id = row.get("Vstore ID")
            self.execute_cmds_with_params(ADMIN_CMDS_WITH_PARAMS, (vstore_id, file_sys_id), (file_sys_id,),
                                          curr_step, each_step)
