#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo, DETAIL_CMD, DETAIL_DES, DETAIL_ID_KEY

# Excel-User
ADMIN_CMDS = [
    {DES: "cmd_display_admin_resource_safe_strategy", CMD: "show resource_user safe_strategy", },
]

ADMIN_CMDS_WITH_DETAIL = [
    {
        DES: "cmd_display_admin_resource_user",
        CMD: "show resource_user general",
        DETAIL_DES: "cmd_display_admin_resource_user_user_id_%s",
        DETAIL_CMD: "show resource_user general user_id=%s",
        DETAIL_ID_KEY: "User ID",
    },
]

VSTORE_CMDS_WITH_PARAM = [
    {DES: "cmd_display_vstore_%s_resource_safe_strategy", CMD: "show resource_user safe_strategy", },
]

VSTORE_CMDS_WITH_DETAIL = [
    {
        DES: "cmd_display_vstore_%s_resource_user",
        CMD: "show resource_user general",
        DETAIL_DES: "cmd_display_vstore_%s_resource_user_user_id_%s",
        DETAIL_CMD: "show resource_user general user_id=%s",
        DETAIL_ID_KEY: "User ID",
    },
]


class HuaweiV3V5UserInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5UserInfo, self).__init__(context)

    def execute(self):
        self.execute_cmds_without_params(ADMIN_CMDS, 5, 10, False)
        self.execute_admin_cmd_with_detail(ADMIN_CMDS_WITH_DETAIL, 15, 30, False)
        self.execute_vstore_cmd_without_detail(VSTORE_CMDS_WITH_PARAM, 45, 10, False, False)
        self.execute_vstore_cmd_with_detail(VSTORE_CMDS_WITH_DETAIL, 55, 35, False)

