#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo

# Excel-User
ADMIN_CMDS = [
    {DES: "cmd_display_admin_identity_mapping_config", CMD: "show identity_mapping config", },
    {DES: "cmd_display_admin_identity_mapping_rule", CMD: "show identity_mapping rule", },
]

VSTORE_CMDS = [
    {DES: "cmd_display_vstore_%s_identity_mapping_config", CMD: "show identity_mapping config", },
    {DES: "cmd_display_vstore_%s_identity_mapping_rule", CMD: "show identity_mapping rule", },
]


class HuaweiV3V5UserMappingInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5UserMappingInfo, self).__init__(context)

    def execute(self):
        self.execute_cmds_without_params(ADMIN_CMDS, 5, 10, False)
        self.execute_vstore_cmd_without_detail(VSTORE_CMDS, 15, 75, False, False)
