#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from common.cmd_execute import DES, CMD
from storages.HUAWEI.nas.v3v5.grab.v3v5_grab_common import HuaweiV3V5GrabInfo

# Excel-Vstore
ADMIN_CMDS = [
    {DES: "cmd_display_admin_show_vstore", CMD: "show vstore"},
]


class HuaweiV3V5VstoreInfo(HuaweiV3V5GrabInfo):
    def __init__(self, context):
        super(HuaweiV3V5VstoreInfo, self).__init__(context)

    def execute(self):
        self.execute_cmds_without_params(ADMIN_CMDS, 5, 5, False)
        self.grab_each_vstore_info()

    def grab_each_vstore_info(self):
        vstores = self.get_vstore()
        curr_step = 10
        progress_width = 85 / len(vstores) if vstores else 85
        commands = []
        for vstore_id in vstores.values():
            commands.append({DES: "cmd_display_admin_vstore_%s_details" % vstore_id,
                             CMD: "show vstore id=%s" % vstore_id})
        self.execute_pure_cmd_list(commands=commands, cur_step=curr_step, progress_width=progress_width)
