#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import copy

from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 CIFS Homedir 映射规则信息
    :param context: 上下文数据
    """
    data_header = ["Vstore ID", "Vstore", "Share ID", "Share Name", "Local Path", "Share Type", "Homedir rule ID",
                   "Homedir rule Name", "Homedir Priority", "Homedir Auto Create", "Homedir Path"]
    parse_data(context, [data_header], get_cifs_homedir_rule_content)


def get_cifs_homedir_rule_content(context):
    data_content = []
    share_id_rules_map = get_cifs_share_id_homedir_rules_mapping(context)
    build_admin_content(context, data_content, share_id_rules_map)
    build_vstore_content(context, data_content, share_id_rules_map)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_admin_content(context, data_content, share_id_rules_map):
    # admin
    vstore_id = SYSTEM_VSTORE_ID
    vstore_name = SYSTEM_VSTORE_NAME
    homedir_cifs_share_table_lines = get_command_result_lines(context, "cmd_display_admin_cifs_share_type_homedir")
    table_data = parse_table_type_result(homedir_cifs_share_table_lines)
    for data in table_data:
        share_id = data.get("Share ID")
        des = "cmd_display_admin_cifs_homedir_share_id_%s" % share_id
        row_data = build_row_data(context, share_id, vstore_id, vstore_name, des)
        update_data_content(share_id, data_content, row_data, share_id_rules_map, vstore_id)


def build_vstore_content(context, data_content, share_id_rules_map):
    # 租户
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, vstore_name in id_name_map.items():
        des = "cmd_display_vstore_%s_cifs_share_type_homedir" % vstore_id
        homedir_cifs_share_table_lines = get_command_result_lines(context, des)
        table_data = parse_table_type_result(homedir_cifs_share_table_lines)
        for data in table_data:
            share_id = data.get("Share ID")
            des = "cmd_display_vstore_%s_cifs_homedir_share_id_%s" % (vstore_id, share_id)
            row_data = build_row_data(context, share_id, vstore_id, vstore_name, des)
            update_data_content(share_id, data_content, row_data, share_id_rules_map, vstore_id)


def build_row_data(context, share_id, vstore_id, vstore_name, des):
    data_dict = get_key_value_type_result(context, des, ":")
    return [vstore_id, vstore_name, share_id, data_dict.get("Name"), data_dict.get("Local Path"),
            data_dict.get("Share Type")]


def update_data_content(share_id, data_content, row_data, share_id_rules_map, vstore_id):
    rules = share_id_rules_map.get(vstore_id + share_id, "")
    for rule in rules:
        new_row_data = copy.deepcopy(row_data)
        new_row_data.extend(rule)
        data_content.append(new_row_data)


def get_cifs_share_id_homedir_rules_mapping(context):
    """
    获取cifs_share_id和cifs_homedir_rule_id映射
    :param context: 上下文
    :return: cifs_share_id和cifs_homedir_rule_id映射
    """
    data_dict = {}
    # admin(默认租户)
    admin_des = "cmd_display_admin_cifs_share_homedir_rule"
    update_cifs_share_id_homedir_rules_dict(context, admin_des, data_dict, SYSTEM_VSTORE_ID)
    # vstore
    vstore_id_name_mapping = get_vstore_id_name_mapping(context)
    for vstore_id in vstore_id_name_mapping.keys():
        vstore_des = "cmd_display_vstore_%s_cifs_share_homedir_rule" % vstore_id
        update_cifs_share_id_homedir_rules_dict(context, vstore_des, data_dict, vstore_id)
    return data_dict


def update_cifs_share_id_homedir_rules_dict(context, des, data_dict, vstore_id):
    cifs_share_homedir_table_lines = get_command_result_lines(context, des)
    table_data = parse_table_type_result(cifs_share_homedir_table_lines)
    for data in table_data:
        key = vstore_id + data.get("Share ID", "")
        rules = data_dict.get(key, [])
        rules.append(
            [data.get("Rule ID"), data.get("Name"), data.get("Priority"), data.get("Auto Create"), data.get("Path")])
        data_dict[key] = rules
