#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 CIFS服务配置信息
    :param context: 上下文数据
    """
    data_header = [
        "Vstore ID", "Vstore", "Max Block Size(byte)", "Listen IP", "Client List",
        "Running Status", "Support SMB3 Protocol", "NTFS Quota Win User Switch", "Security Model", "Guest Enabled",
        "Anonymous Enabled", "Signing Required", "Signing Enabled", "Oplock Enabled", "Notify Enabled",
        "Durable Handle Enabled", "ABSE Enabled", "SMB1 Enabled", "SMB2 Enabled", "Short Name Enabled",
        "Continuous QueryDir Enabled", "Mac Transcoding Enabled", "Default Dir Mode", "Default File Mode",
        "Global Namespace Capacity", "Global Namespace Forward Enabled", "SMB2 Enabled for DC Connections",
        "LeaseV2 Enabled", "Smb1 Enabled for Linux", "Max Sessions Display", "Max Open Files Display",
        "Symlink Enabled", "Domain Name Configurable Enable", "I/O Trace Enabled", "Administrators Privilege",
        "NTLM Logonex Enable", "Cifs Symlink Enable", "Client Session Security For AD LDAP",
        "SMB1 Priority for DC Connections", "Inherit Parent Mode Enable", "NTFS SetAcl Chown Disable",
        "CIFS_Reserve_bit"]
    parse_data(context, [data_header], get_cifs_service_conf_content)


def get_cifs_service_conf_content(context):
    data_content = []
    build_admin_content(context, data_content)
    build_vstore_content(context, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_admin_content(context, data_content):
    # admin(默认租户)
    vstore_id = SYSTEM_VSTORE_ID
    vstore_name = SYSTEM_VSTORE_NAME
    common_conf_dic = get_key_value_type_result(context, "cmd_display_admin_cifs_service_config", ":")
    cifs_service_dic = get_key_value_type_result(context, "cmd_display_admin_cifs_service", ":")
    reserve_bit_des = "cmd_display_admin_cifs_reserve_bit_tenantid_equals_0"
    reserve_bit_dic = get_key_value_type_result(context, reserve_bit_des, ":")
    row_data = [vstore_id, vstore_name]
    update_row_data(row_data, common_conf_dic, cifs_service_dic, reserve_bit_dic)
    data_content.append(row_data)


def build_vstore_content(context, data_content):
    # 租户
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, vstore_name in id_name_map.items():
        common_conf_dic = get_key_value_type_result(context, "cmd_display_admin_cifs_service_config", ":")
        cifs_service_des = "cmd_display_vstore_%s_cifs_service" % vstore_id
        cifs_service_dic = get_key_value_type_result(context, cifs_service_des, ":")
        reserve_bit_des = "cmd_display_vstore_%s_cifs_reserve_bit" % vstore_id
        reserve_bit_dic = get_key_value_type_result(context, reserve_bit_des, ":")
        row_data = [vstore_id, vstore_name]
        update_row_data(row_data, common_conf_dic, cifs_service_dic, reserve_bit_dic)
        data_content.append(row_data)


def update_row_data(row_data, common_conf_dic, cifs_service_dic, reserve_bit_dic):
    row_data.extend([
        common_conf_dic.get("Max Block Size(byte)"), common_conf_dic.get("Listen IP"),
        common_conf_dic.get("Client List"), cifs_service_dic.get("Running Status"),
        common_conf_dic.get("Support SMB3 Protocol"), common_conf_dic.get("NTFS Quota Win User Switch"),
        cifs_service_dic.get("Security Model"), cifs_service_dic.get("Guest Enabled"),
        cifs_service_dic.get("Anonymous Enabled"), cifs_service_dic.get("Signing Required"),
        cifs_service_dic.get("Signing Enabled"), cifs_service_dic.get("Oplock Enabled"),
        cifs_service_dic.get("Notify Enabled"), cifs_service_dic.get("Durable Handle Enabled"),
        cifs_service_dic.get("ABSE Enabled"), cifs_service_dic.get("SMB1 Enabled"),
        cifs_service_dic.get("SMB2 Enabled"), cifs_service_dic.get("Short Name Enabled"),
        cifs_service_dic.get("Continuous QueryDir Enabled"), cifs_service_dic.get("Mac Transcoding Enabled"),
        cifs_service_dic.get("Default Dir Mode"), cifs_service_dic.get("Default File Mode"),
        cifs_service_dic.get("Global Namespace Capacity"), cifs_service_dic.get("Global Namespace Forward Enabled"),
        cifs_service_dic.get("SMB2 Enabled for DC Connections"), cifs_service_dic.get("LeaseV2 Enabled"),
        cifs_service_dic.get("Smb1 Enabled for Linux"), cifs_service_dic.get("Max Sessions Display"),
        cifs_service_dic.get("Max Open Files Display"), cifs_service_dic.get("Symlink Enabled"),
        cifs_service_dic.get("Domain Name Configurable Enable"), cifs_service_dic.get("I/O Trace Enabled"),
        cifs_service_dic.get("Administrators Privilege"), cifs_service_dic.get("NTLM Logonex Enable"),
        cifs_service_dic.get("Cifs Symlink Enable"), cifs_service_dic.get("Client Session Security For AD LDAP"),
        cifs_service_dic.get("SMB1 Priority for DC Connections"), cifs_service_dic.get("Inherit Parent Mode Enable"),
        cifs_service_dic.get("NTFS SetAcl Chown Disable"), reserve_bit_dic.get("Reservebit Value")])
