#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import copy

from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 每个租户下的CIFS共享的文件扩展
    :param context: 上下文数据
    """
    data_header = ["Vstore ID", "Vstore", "Sid Mapping Enable", "From Sid", "To Sid", "To Name", "Mapping Type",
                   "CIFS Migration Reserve Unix Security", "Sid Prefix For U In UNIX MODE",
                   "Sid Prefix For G In UNIX MODE", "Sid For O In UNIX MODE", "Sid For SUID In UNIX MODE",
                   "Sid For SGID In UNIX MODE", "Sid For SVTX In UNIX MODE"]
    parse_data(context, [data_header], get_cifs_share_ip_control_content)


def get_cifs_share_ip_control_content(context):
    data_content = []
    build_admin_content(context, data_content)
    build_vstore_content(context, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_admin_content(context, data_content):
    # admin(默认租户)
    vstore_id = SYSTEM_VSTORE_ID
    vstore_name = SYSTEM_VSTORE_NAME
    des = "cmd_display_admin_sid_mapping_config"
    sid_mapping_enable = get_sid_mapping_status(context, des)
    fs_security_dic = get_key_value_type_result(context, "cmd_display_admin_fs_security", ":")
    sid_mapping_rule_table_lines = get_command_result_lines(context, "cmd_display_admin_sid_mapping_rule")
    table_data = parse_table_type_result(sid_mapping_rule_table_lines)
    row_data = [vstore_id, vstore_name]
    update_row_data(row_data, table_data, fs_security_dic, data_content, sid_mapping_enable)


def build_vstore_content(context, data_content):
    # 租户
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, vstore_name in id_name_map.items():
        des = "cmd_display_vstore_%s_sid_mapping_config" % vstore_id
        sid_mapping_enable = get_sid_mapping_status(context, des)
        fs_security_dic = get_key_value_type_result(context, "cmd_display_vstore_%s_fs_security" % vstore_id, ":")
        row_data = [vstore_id, vstore_name]
        sid_mapping_rue_des = "cmd_display_vstore_%s_sid_mapping_rule" % vstore_id
        sid_mapping_rule_table_lines = get_command_result_lines(context, sid_mapping_rue_des)
        table_data = parse_table_type_result(sid_mapping_rule_table_lines)
        update_row_data(row_data, table_data, fs_security_dic, data_content, sid_mapping_enable)


def update_row_data(row_data, table_data, fs_security_dic, data_content, sid_mapping_enable):
    cifs_migration_reserve_unix_security = fs_security_dic.get("CIFS Migration Reserve Unix Security")
    sid_prefix_for_u = fs_security_dic.get("Sid Prefix For U In UNIX MODE")
    sid_prefix_for_g = fs_security_dic.get("Sid Prefix For G In UNIX MODE")
    sid_for_o = fs_security_dic.get("Sid For O In UNIX MODE")
    sid_for_suid = fs_security_dic.get("Sid For SUID In UNIX MODE")
    sid_for_sgid = fs_security_dic.get("Sid For SGID In UNIX MODE")
    sid_for_svtx = fs_security_dic.get("Sid For SVTX In UNIX MODE")
    if table_data:
        for data in table_data:
            new_row_data = copy.deepcopy(row_data)
            new_row_data.extend([sid_mapping_enable, data.get("From Sid"), data.get("To Sid"), data.get("To Name"),
                                 data.get("Mapping Type"), cifs_migration_reserve_unix_security, sid_prefix_for_u,
                                 sid_prefix_for_g, sid_for_o, sid_for_suid, sid_for_sgid, sid_for_svtx])
            data_content.append(new_row_data)
    else:
        row_data.extend([sid_mapping_enable, "", "", "", "", cifs_migration_reserve_unix_security, sid_prefix_for_u,
                         sid_prefix_for_g, sid_for_o, sid_for_suid, sid_for_sgid, sid_for_svtx])
        data_content.append(row_data)


def get_sid_mapping_status(context, des):
    sid_mapping_dic = get_key_value_type_result(context, des, ":")
    sid_mapping_enable = sid_mapping_dic.get("Sid Mapping Enable")
    return sid_mapping_enable
