# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import copy

from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 每个租户下的CIFS共享的可访问的IP地址/地址段
    :param context: 上下文数据
    """
    data_header = ["Vstore ID", "Vstore", "Share ID", "Share Name", "Local Path", " Rule ID", "IP Control Rule"]
    parse_data(context, [data_header], get_cifs_share_ip_control_content)


def get_cifs_share_ip_control_content(context):
    data_content = []
    share_id_ip_rule_map = get_cifs_share_id_ip_rules_mapping(context)
    build_admin_content(context, data_content, share_id_ip_rule_map)
    build_vstore_content(context, data_content, share_id_ip_rule_map)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_admin_content(context, data_content, share_id_ip_rules_map):
    # admin
    vstore_id = SYSTEM_VSTORE_ID
    vstore_name = SYSTEM_VSTORE_NAME
    cifs_share_table_lines = get_command_result_lines(context, "cmd_display_admin_cifs_share")
    table_data = parse_table_type_result(cifs_share_table_lines)
    for data in table_data:
        share_id = data.get("Share ID")
        des = "cmd_display_admin_cifs_share_id_%s" % share_id
        row_data = build_row_data(context, share_id, vstore_id, vstore_name, des)
        update_data_content(share_id, data_content, row_data, share_id_ip_rules_map, vstore_id)


def build_vstore_content(context, data_content, share_id_ip_rules_map):
    # 租户
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, vstore_name in id_name_map.items():
        des = "cmd_display_vstore_%s_cifs_share" % vstore_id
        cifs_share_table_lines = get_command_result_lines(context, des)
        table_data = parse_table_type_result(cifs_share_table_lines)
        for data in table_data:
            share_id = data.get("Share ID")
            des = "cmd_display_vstore_%s_cifs_share_id_%s" % (vstore_id, share_id)
            row_data = build_row_data(context, share_id, vstore_id, vstore_name, des)
            update_data_content(share_id, data_content, row_data, share_id_ip_rules_map, vstore_id)


def build_row_data(context, share_id, vstore_id, vstore_name, des):
    data_dict = get_key_value_type_result(context, des, ":")
    return [vstore_id, vstore_name, share_id, data_dict.get("Name"), data_dict.get("Local Path")]


def update_data_content(share_id, data_content, row_data, share_id_ip_rule_ids_map, vstore_id):
    ip_rules = share_id_ip_rule_ids_map.get(vstore_id + share_id, "")
    for ip_rule in ip_rules:
        new_row_data = copy.deepcopy(row_data)
        new_row_data.extend(ip_rule)
        data_content.append(new_row_data)


def get_cifs_share_id_ip_rules_mapping(context):
    """
    获取cifs_share_id和ip_rules映射
    :param context: 上下文
    :return: cifs_share_id和ip_rules映射
    """
    data_dict = {}
    # admin(默认租户)
    admin_des = "cmd_display_admin_cifs_share_ip_control"
    update_cifs_share_id_ip_rule_dict(context, admin_des, data_dict, SYSTEM_VSTORE_ID)
    # vstore
    vstore_id_name_mapping = get_vstore_id_name_mapping(context)
    for vstore_id in vstore_id_name_mapping.keys():
        vstore_des = "cmd_display_vstore_%s_cifs_share_ip_control" % vstore_id
        update_cifs_share_id_ip_rule_dict(context, vstore_des, data_dict, vstore_id)
    return data_dict


def update_cifs_share_id_ip_rule_dict(context, des, data_dict, vstore_id):
    cifs_share_ip_control_table_lines = get_command_result_lines(context, des)
    table_data = parse_table_type_result(cifs_share_ip_control_table_lines)
    for data in table_data:
        key = vstore_id + data.get("Share ID", "")
        ip_rules = data_dict.get(key, [])
        ip_rules.append([data.get("Rule ID"), data.get("Rule")])
        data_dict[key] = ip_rules
