#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 CIFS共享信息
    :param context: 上下文数据
    """
    data_header = ["Vstore ID", "Vstore", "Share ID", "Share Name", "Share Description", "Local Path", "Share Type",
                   "Oplock Enabled", "Notify Enabled", "Continue Available Enabled", "Offline File Mode",
                   "Smb2 CA Enabled", "IP Access Control", "ABE Enabled", "Audit Items", "File Extenson Filter",
                   "Apply Default ACL", "Show Previous Versions Enabled", "Show Snapshot Enabled", "Browse Enabled",
                   "Readdir Timeout(s)"]
    parse_data(context, [data_header], get_cifs_homedir_rule_content)


def get_cifs_homedir_rule_content(context):
    data_content = []
    build_admin_content(context, data_content)
    build_vstore_content(context, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_admin_content(context, data_content):
    # admin
    vstore_id = SYSTEM_VSTORE_ID
    vstore_name = SYSTEM_VSTORE_NAME
    cifs_share_table_lines = get_command_result_lines(context, "cmd_display_admin_cifs_share")
    table_data = parse_table_type_result(cifs_share_table_lines)
    for data in table_data:
        share_id = data.get("Share ID")
        des = "cmd_display_admin_cifs_share_id_%s" % share_id
        row_data = [vstore_id, vstore_name, share_id]
        update_row_data(context, des, row_data)
        data_content.append(row_data)


def build_vstore_content(context, data_content):
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, vstore_name in id_name_map.items():
        cifs_share_table_lines = get_command_result_lines(context, "cmd_display_vstore_%s_cifs_share" % vstore_id)
        table_data = parse_table_type_result(cifs_share_table_lines)
        for data in table_data:
            share_id = data.get("Share ID")
            des = "cmd_display_vstore_%s_cifs_share_id_%s" % (vstore_id, share_id)
            row_data = [vstore_id, vstore_name, share_id]
            update_row_data(context, des, row_data)
            data_content.append(row_data)


def update_row_data(context, des, row_data):
    data_dic = get_key_value_type_result(context, des, ":")
    row_data.extend([data_dic.get("Name"), data_dic.get("Description"), data_dic.get("Local Path"),
                     data_dic.get("Share Type"), data_dic.get("Oplock Enabled"), data_dic.get("Notify Enabled"),
                     data_dic.get("Continue Available Enabled"), data_dic.get("Offline File Mode"),
                     data_dic.get("Smb2 CA Enabled"), data_dic.get("IP Access Control"), data_dic.get("ABE Enabled"),
                     data_dic.get("Audit Items"), data_dic.get("File Extenson Filter"),
                     data_dic.get("Apply Default ACL"), data_dic.get("Show Previous Versions Enabled"),
                     data_dic.get("Show Snapshot Enabled"), data_dic.get("Browse Enabled"),
                     data_dic.get("Readdir Timeout(s)")
                     ])
