#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import (get_vstore_id_name_mapping, parse_data, get_first_number_from_string,
                                                   vstore_id_to_sort, get_key_value_type_result)
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 重删压缩信息
    :param context: 上下文数据
    """
    data_header = [
        "Vstore ID", "Vstore", "Filesystem ID", "Filesystem Name", "Dedup Enabled",
        "Byte_by_byte Comparison Enabled", "Compression Enabled", "Compression Method", "Used Capacity",
        "Total Saved Capacity", "Total Saved Ratio(%)", "Dedup Saved Capacity", "Compression Saved Capacity",
        "Compression Saved Ratio(%)", "Dedup Checksum Enabled", "Background Dedup Enabled",
        "Background Compression Enabled"
    ]
    parse_data(context, [data_header], get_deduplicated_compress_data)


def get_deduplicated_compress_data(context):
    data_content = []
    build_data_content(context, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_data_content(context, data_content):
    id_and_names_map = get_vstore_id_file_system_ids_mapping(context)
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, file_system_ids in id_and_names_map.items():
        vstore_name = id_name_map.get(vstore_id, SYSTEM_VSTORE_NAME)
        for file_system_id in file_system_ids:
            des = "cmd_display_vstore_%s_file_system_id=%s" % (vstore_id, file_system_id)
            data_dict = get_key_value_type_result(context, des, ":")
            row_data = build_row_content(vstore_id, vstore_name, file_system_id, data_dict)
            data_content.append(row_data)


def get_vstore_id_file_system_ids_mapping(context):
    des = "cmd_display_admin_file_system_general"
    result = get_command_result_lines(context, des)
    table_data = parse_table_type_result(result)
    data_dict = {}
    for data in table_data:
        vstore_id = data.get("Vstore ID")
        file_system_ids = data_dict.get(vstore_id, [])
        file_system_ids.append(data.get("ID"))
        data_dict[vstore_id] = file_system_ids
    return data_dict


def build_row_content(vstore_id, vstore_name, file_system_id, data_dict):
    """
    构建data_content的每一行的内容
    :param vstore_id: 租户id,默认租户为”--“
    :param vstore_name: 租户名字，默认租户为"--"
    :param file_system_id: 文件系统id
    :param data_dict: key:value键值对
    """
    file_system_name = data_dict.get("Name")
    dedup_enabled = data_dict.get("Dedup Enabled")
    byte_by_byte_comparison_enabled = data_dict.get("Byte_by_byte Comparison Enabled")
    compression_enabled = data_dict.get("Compression Enabled")
    compression_method = data_dict.get("Compression Method")
    used_capacity = str(get_first_number_from_string(data_dict.get("Capacity")) * get_first_number_from_string(
        data_dict.get("Used Capacity Ratio(%)")) / 100)
    total_saved_capacity = data_dict.get("Total Saved Capacity")
    total_saved_ratio = data_dict.get("Total Saved Ratio(%)")
    dedup_saved_capacity = data_dict.get("Dedup Saved Capacity")
    compression_saved_capacity = data_dict.get("Compression Saved Capacity")
    compression_saved_ratio = data_dict.get("Compression Saved Ratio(%)")
    dedup_checksum_enabled = data_dict.get("Dedup Checksum Enabled")
    background_dedup_enabled = data_dict.get("Background Dedup Enabled")
    background_compression_enabled = data_dict.get("Background Compression Enabled")
    return [
        vstore_id, vstore_name, file_system_id, file_system_name, dedup_enabled,
        byte_by_byte_comparison_enabled, compression_enabled, compression_method, used_capacity,
        total_saved_capacity, total_saved_ratio, dedup_saved_capacity, compression_saved_capacity,
        compression_saved_ratio, dedup_checksum_enabled, background_dedup_enabled, background_compression_enabled
    ]
