#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 DNS、AD、LADP、NIS、DNS_ZONE域认证信息
    :param context: 上下文数据
    """
    parent_title = [
        # vstore
        "Vstore Info", "Vstore Info",
        # DNS
        "DNS Configuration", "DNS Configuration",
        # AD Domain
        "AD Domain Configuration", "AD Domain Configuration", "AD Domain Configuration", "AD Domain Configuration",
        # LDAP
        "LDAP Configuration", "LDAP Configuration", "LDAP Configuration", "LDAP Configuration", "LDAP Configuration",
        "LDAP Configuration", "LDAP Configuration", "LDAP Configuration", "LDAP Configuration", "LDAP Configuration",
        "LDAP Configuration",
        # NIS
        "NIS Configuration", "NIS Configuration",
    ]
    sub_title = [
        # vstore
        "Vstore ID", "Vstore Name",
        # DNS
        "DNS_IP List", "DNS_Domains",
        # AD Domain
        "Domain Status", "Full Domain Name", "Organization Unit", "pref_Domain Controller Name",
        # LDAP
        "LDAP_IP List", "Port", "Transfer Type", "Base DN", "Bind Using the AD Credentials",
        "Bind Authentication Level", "User Search Scope", "Group Search Scope", "Netgroup Search Scope",
        "Bind DN", "Client Session Security",
        # NIS
        "NIS Name", "NIS_IP List",
    ]
    data_header = [parent_title, sub_title]
    parse_data(context, data_header, get_domain_content)


def get_domain_content(context):
    data_content = []
    # 默认租户
    build_admin_data_content(context, data_content)
    # 租户
    build_vstore_data_content(context, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_admin_data_content(context, data_content):
    vstore_id = SYSTEM_VSTORE_ID
    vstore_name = SYSTEM_VSTORE_NAME
    dns_data_dict = get_content_and_parse(context, "cmd_display_admin_domain_dns_info")
    ad_data_dict = get_content_and_parse(context, "cmd_display_admin_domain_ad_info")
    ad_prefdc_data_dict = get_content_and_parse(context, "cmd_display_admin_domain_ad_prefdc")
    ldap_data_dict = get_content_and_parse(context, "cmd_display_admin_domain_ldap_info")
    nis_data_dict = get_content_and_parse(context, "cmd_display_admin_domain_nis_info")
    row_data = [vstore_id, vstore_name, dns_data_dict.get("IP Address List"), dns_data_dict.get("Domains")]
    build_row_of_data_content(row_data, ad_data_dict, ad_prefdc_data_dict, ldap_data_dict, nis_data_dict)
    data_content.append(row_data)


def build_vstore_data_content(context, data_content):
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, vstore_name in id_name_map.items():
        dns_data_dict = get_content_and_parse(context, "cmd_display_vstore_%s_domain_dns_info" % vstore_id)
        ad_data_dict = get_content_and_parse(context, "cmd_display_vstore_%s_domain_ad_info" % vstore_id)
        ad_prefdc_data_dict = get_content_and_parse(context, "cmd_display_vstore_%s_domain_ad_prefdc" % vstore_id)
        ldap_data_dict = get_content_and_parse(context, "cmd_display_vstore_%s_domain_ldap_info" % vstore_id)
        nis_data_dict = get_content_and_parse(context, "cmd_display_vstore_%s_domain_nis_info" % vstore_id)
        row_data = [vstore_id, vstore_name, dns_data_dict.get("IP Address List"), dns_data_dict.get("Domains")]
        build_row_of_data_content(row_data, ad_data_dict, ad_prefdc_data_dict, ldap_data_dict, nis_data_dict)
        data_content.append(row_data)


def build_row_of_data_content(row_data, ad_data_dict, ad_prefdc_data_dict, ldap_data_dict, nis_data_dict):
    row_data.extend([
        ad_data_dict.get("Domain Status"), ad_data_dict.get("Full Domain Name"),
        ad_data_dict.get("Organization Unit"), ad_prefdc_data_dict.get("Domain Controller Name"),
        ldap_data_dict.get("IP Address List"), ldap_data_dict.get("Port"),
        ldap_data_dict.get("Transfer Type"),
        ldap_data_dict.get("Base DN"), ldap_data_dict.get("Bind Using the AD Credentials"),
        ldap_data_dict.get("Bind Authentication Level"), ldap_data_dict.get("User Search Scope"),
        ldap_data_dict.get("Group Search Scope"), ldap_data_dict.get("Netgroup Search Scope"),
        ldap_data_dict.get("Bind DN"), ldap_data_dict.get("Client Session Security"),
        nis_data_dict.get("Name"), nis_data_dict.get("IP Address List")])


def get_content_and_parse(context, des):
    data_dict = get_key_value_type_result(context, des, ":")
    return data_dict
