#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 文件系统信息
    :param context: 上下文数据
    """
    data_header = ["Vstore ID", "Vstore", "Filesystem ID", "Filesystem Name", "Health Status",
                   "Running Status", "Capacity", "Allocated Capacity", "Available Capacity", "Used Capacity Ratio(%)",
                   "Snapshot Reserve(%)", "Type", "Application Scenario", "Block Size", "Security Style",
                   "Owner Controller", "Work Controller", "Capacity Threshold(%)", "Show Snapshot Directory Enabled",
                   "Timing Snapshot Max Number", "Auto Delete Snapshot Enabled", "Checksum Enabled", "Atime Enabled",
                   "Alternate Data Streams Enabled", "Long Filename Enabled", "Description", "Snapshot Used Capacity",
                   "Snapshot Reserve Capacity", "Timing Snapshot Enabled", "Timing Snapshot Schedule ID",
                   "Snapshot Background Freeing Capacity", "Read Write Status", "Sub Type", "Description"]
    parse_data(context, [data_header], get_file_system_data)


def get_file_system_data(context):
    data_content = []
    build_data_content(context, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_data_content(context, data_content):
    id_and_names_map = get_vstore_id_file_system_ids_mapping(context)
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, file_system_ids in id_and_names_map.items():
        vstore_name = id_name_map.get(vstore_id, SYSTEM_VSTORE_NAME)
        for file_system_id in file_system_ids:
            des = "cmd_display_vstore_%s_file_system_id=%s" % (vstore_id, file_system_id)
            data_dict = get_key_value_type_result(context, des, ":")
            row_data = build_row_data(vstore_id, vstore_name, file_system_id, data_dict)
            data_content.append(row_data)


def get_vstore_id_file_system_ids_mapping(context):
    des = "cmd_display_admin_file_system_general"
    result = get_command_result_lines(context, des)
    table_data = parse_table_type_result(result)
    data_dict = {}
    for data in table_data:
        vstore_id = data.get("Vstore ID")
        file_system_ids = data_dict.get(vstore_id, [])
        file_system_ids.append(data.get("ID"))
        data_dict[vstore_id] = file_system_ids
    return data_dict


def build_row_data(vstore_id, vstore_name, file_system_id, data_dict):
    return [vstore_id, vstore_name, file_system_id,
            data_dict.get("Name"), data_dict.get("Health Status"), data_dict.get("Running Status"),
            data_dict.get("Capacity"), data_dict.get("Allocated Capacity"), data_dict.get("Available Capacity"),
            data_dict.get("Used Capacity Ratio(%)"), data_dict.get("Snapshot Reserve(%)"), data_dict.get("Type"),
            data_dict.get("Application Scenario"), data_dict.get("Block Size"), data_dict.get("Security Style"),
            data_dict.get("Owner Controller"), data_dict.get("Work Controller"), data_dict.get("Capacity Threshold(%)"),
            data_dict.get("Show Snapshot Directory Enabled"), data_dict.get("Timing Snapshot Max Number"),
            data_dict.get("Auto Delete Snapshot Enabled"), data_dict.get("Checksum Enabled"),
            data_dict.get("Atime Enabled"), data_dict.get("Alternate Data Streams Enabled"),
            data_dict.get("Long Filename Enabled"), data_dict.get("Description"),
            data_dict.get("Snapshot Used Capacity"), data_dict.get("Snapshot Reserve Capacity"),
            data_dict.get("Timing Snapshot Enabled"), data_dict.get("Timing Snapshot Schedule ID"),
            data_dict.get("Snapshot Background Freeing Capacity"), data_dict.get("Read Write Status"),
            data_dict.get("Sub Type"), data_dict.get("Description")]
