#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 本地用户组信息
    :param context: 上下文数据
    """
    data_header = ["Vstore ID", "Vstore", "Group ID", "Group Name", "Description", "Group Type", "Ad_group Name",
                   "Ad_user Name", "SID Prefix", "SID Suffix", "Type"]
    parse_data(context, [data_header], get_group_content)


def get_group_content(context):
    data_content = []
    build_admin_content(context, data_content)
    build_vstore_content(context, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_admin_content(context, data_content):
    # admin
    vstore_id = SYSTEM_VSTORE_ID
    vstore = SYSTEM_VSTORE_NAME
    group_table_lines = get_command_result_lines(context, "cmd_display_admin_resource_group")
    table_data = parse_table_type_result(group_table_lines)
    for data in table_data:
        group_id = data.get("Resource Group ID")
        des = "cmd_display_admin_resource_group_group_id_%s" % group_id
        data_dict = get_key_value_type_result(context, des, ":")
        ad_group_des = "cmd_display_admin_resource_group_ad_group_group_id_%s" % group_id
        ad_group_names = get_specified_columns_from_group_grab(context, ad_group_des)
        ad_user_group_des = "cmd_display_admin_resource_group_ad_user_group_id_%s" % group_id
        ad_user_names = get_specified_columns_from_group_grab(context, ad_user_group_des)
        row_data = [vstore_id, vstore, group_id]
        build_row_of_data_content(row_data, data_dict, group_id, ad_group_names, ad_user_names)
        data_content.append(row_data)


def build_vstore_content(context, data_content):
    # 租户
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, vstore_name in id_name_map.items():
        group_table_lines = get_command_result_lines(context, "cmd_display_vstore_%s_resource_group" % vstore_id)
        table_data = parse_table_type_result(group_table_lines)
        for data in table_data:
            group_id = data.get("Resource Group ID")
            des = "cmd_display_vstore_%s_resource_group_group_id_%s" % (vstore_id, group_id)
            data_dict = get_key_value_type_result(context, des, ":")
            ad_group_des = "cmd_display_vstore_%s_resource_group_ad_group_group_id_%s" % (vstore_id, group_id)
            ad_group_names = get_specified_columns_from_group_grab(context, ad_group_des)
            ad_user_group_des = "cmd_display_vstore_%s_resource_group_ad_user_group_id_%s" % (vstore_id, group_id)
            ad_user_names = get_specified_columns_from_group_grab(context, ad_user_group_des)
            row_data = [vstore_id, vstore_name, group_id]
            build_row_of_data_content(row_data, data_dict, group_id, ad_group_names, ad_user_names)
            data_content.append(row_data)


def build_row_of_data_content(row_data, data_dict, group_id, ad_group_names, ad_user_names):
    sid_suffix = str(float(group_id) + 2147483648).split(".")[0]
    row_data.extend([
        data_dict.get("Resource Group Name"), data_dict.get("Description"), data_dict.get("Group Type"), ad_group_names,
        ad_user_names, "S-1-6-88", sid_suffix, "All"])


def get_specified_columns_from_group_grab(context, cmd_des):
    """
    从本地用户组采集中根据des获取指定列集合的元素
    ID      ...   Name
    ------  ...   ---------
    LGU     ...   1
    fs001   ...   2
    :param context: 上下文数据
    :param cmd_des: 命令des
    @return: 逗号分隔的指定列元素的集合
    """
    table_lines = get_command_result_lines(context, cmd_des)
    data_dict = parse_table_type_result(table_lines)
    names = []
    for data in data_dict:
        names.append(data.get("Name"))
    return ','.join(names)
