#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取V3/V5 双活信息
    :param context: 上下文数据
    """
    data_header = [
        "Hyper Metro ID", "Local Name", "Remote Name", "Role", "Active/Passive", "Recovery Policy", "Vstore Pair ID",
        "Local Vstore Name", "Remote Vstore Name", "Remote Device Name", "Remote Device SN"
    ]
    parse_data(context, [data_header], get_hyper_metro_content)


def get_hyper_metro_content(context):
    """
    1. 获取ID
    2. 拼接show hyper_metro_pair general pair_id=%s获取双活回显信息
    3. 如步骤2中有Vstore Pair ID，则获取Local Vstore Name和Remote Vstore Name
    4. 如步骤2中有Domain Id，获取Remote Device ID
    5. 步骤4中获取Remote Device ID，然后获取Remote Device Name和Remote Device SN
    """
    data_content = []
    hyper_metro_ids = get_hyper_metro_ids(context)
    vstore_pair_id_map = get_vstore_pair_id_vstore_names_mapping(context)
    domain_id_map = get_domain_id_remote_device_id_mapping(context)
    device_id_map = get_device_id_device_info_mapping(context)
    for hyper_metro_id in hyper_metro_ids:
        pair_des = "cmd_display_admin_hyper_metro_pair_general_pair_id=%s" % hyper_metro_id
        pair_data_dict = get_key_value_type_result(context, pair_des, ":", False)
        vstore_pair_id = pair_data_dict.get("Vstore Pair ID", "--")
        row_data = [hyper_metro_id, pair_data_dict.get("Local Name"), pair_data_dict.get("Remote Name"),
                    pair_data_dict.get("Role"), pair_data_dict.get("Active/Passive"),
                    pair_data_dict.get("Recovery Policy"), vstore_pair_id]
        row_data.extend(vstore_pair_id_map.get(vstore_pair_id))
        domain_id = pair_data_dict.get("Domain ID")
        device_id = domain_id_map.get(domain_id, "--")
        row_data.extend(device_id_map.get(device_id[0]))
        data_content.append(row_data)
    return data_content


def get_hyper_metro_ids(context):
    hyper_metro_ids = []
    hyper_metro_table_lines = get_command_result_lines(context, "cmd_display_admin_hyper_metro_pair_general")
    table_data = parse_table_type_result(hyper_metro_table_lines)
    for data in table_data:
        hyper_metro_ids.append(data.get("ID"))
    return hyper_metro_ids


def get_vstore_pair_id_vstore_names_mapping(context):
    des = "cmd_display_admin_hyper_metro_vstore_pair_general"
    table_lines = get_command_result_lines(context, des)
    table_data = parse_table_type_result(table_lines)
    pair_id_vstore_names_dict = {}
    for data in table_data:
        pair_id_vstore_names_dict[data.get("ID")] = [data.get("Local Vstore Name"), data.get("Remote Vstore Name")]
    pair_id_vstore_names_dict["--"] = ["", ""]
    return pair_id_vstore_names_dict


def get_domain_id_remote_device_id_mapping(context):
    des = "cmd_display_admin_hyper_metro_domain_general"
    table_lines = get_command_result_lines(context, des)
    table_data = parse_table_type_result(table_lines)
    domain_id_device_id_dict = {}
    for data in table_data:
        domain_id_device_id_dict[data.get("ID")] = [data.get("Remote Device ID")]
    domain_id_device_id_dict["--"] = [""]
    return domain_id_device_id_dict


def get_device_id_device_info_mapping(context):
    des = "cmd_display_admin_remote_device_general"
    table_lines = get_command_result_lines(context, des)
    table_data = parse_table_type_result(table_lines)
    device_id_info_dict = {}
    for data in table_data:
        device_id_info_dict[data.get("ID")] = [data.get("Name"), data.get("SN")]
    device_id_info_dict["--"] = ["", ""]
    return device_id_info_dict
