#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 逻辑端口信息
    :param context: 上下文数据
    """
    data_header = ["Vstore ID", "Vstore", "Logical Port Name", "Running Status", "Activation Status", "IPv4 Address",
                   "IPv4 Mask", "IPv4 Gateway", "IPv6 Address", "IPv6 Mask", "IPv6 Gateway", "Home Port Type",
                   "Home Port ID", "Owner Controller ID", "Current Port Type", "Current Port ID", "Role",
                   "Work Controller ID ", "Support Protocol", "Address Family", "Is Private", "Failover Group ID",
                   "Failover Enabled", "Failback Mode", "Management Access", "DDNS Status", "DNS Zone Name",
                   "Listen DNS Query Enabled"]
    parse_data(context, [data_header], get_logical_port_content)


def get_logical_port_content(context):
    data_content = []
    build_data_content(context, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_data_content(context, data_content):
    id_and_names_map = get_vstore_id_logical_port_names_mapping(context)
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, logical_port_names in id_and_names_map.items():
        vstore_name = id_name_map.get(vstore_id, SYSTEM_VSTORE_NAME)
        for name in logical_port_names:
            des = "cmd_display_vstore_%s_logical_port_name_%s" % (vstore_id, name)
            data_dict = get_key_value_type_result(context, des, ":")
            row_data = build_row_data(data_dict, vstore_id, vstore_name, name)
            data_content.append(row_data)


def get_vstore_id_logical_port_names_mapping(context):
    des = "cmd_display_admin_logical_port"
    result = get_command_result_lines(context, des)
    table_data = parse_table_type_result(result)
    data_dict = {}
    for data in table_data:
        vstore_id = data.get("vStore ID")
        logical_port_names = data_dict.get(vstore_id, [])
        logical_port_names.append(data.get("Logical Port Name"))
        data_dict[vstore_id] = logical_port_names
    return data_dict


def build_row_data(data_dict, vstore_id, vstore_name, logical_port_name):
    return [vstore_id, vstore_name, logical_port_name,
            data_dict.get("Running Status"), data_dict.get("Activation Status"), data_dict.get("IPv4 Address"),
            data_dict.get("IPv4 Mask"), data_dict.get("IPv4 Gateway"), data_dict.get("IPv6 Address"),
            data_dict.get("IPv6 Mask"), data_dict.get("IPv6 Gateway"), data_dict.get("Home Port Type"),
            data_dict.get("Home Port ID"), data_dict.get("Owner Controller ID"),
            data_dict.get("Current Port Type"), data_dict.get("Current Port ID"), data_dict.get("Role"),
            data_dict.get("Work Controller ID"), data_dict.get("Support Protocol"),
            data_dict.get("Address Family"), data_dict.get("Is Private"), data_dict.get("Failover Group ID"),
            data_dict.get("Failover Enabled"), data_dict.get("Failback Mode"),
            data_dict.get("Management Access"), data_dict.get("DDNS Status"), data_dict.get("DNS Zone Name"),
            data_dict.get("Listen DNS Query Enabled")]
