#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 NFS服务配置信息
    :param context: 上下文数据
    """
    data_header = [
        "Vstore ID", "Vstore", "Support V3 Enabled", "Support V4 Enabled", "V4 Domain Name",
        "V3 ACL Enabled", "Support V41 Enabled", "Listen IP", "Client List", "Fileid Length(bit)",
        "Extended Groups Switch", "Extended Groups Limit", "Nobody UID", "Ignore NT ACL For Root",
        "Global V4 Acl Preserve", "Global Ntfs Unix Security Ops", "Touch check with ACL ", "NFS_Reserve_bit"]
    parse_data(context, [data_header], get_nfs_service_conf_content)


def get_nfs_service_conf_content(context):
    data_content = []
    build_admin_content(context, data_content)
    build_vstore_content(context, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_admin_content(context, data_content):
    # admin
    vstore_id = SYSTEM_VSTORE_ID
    vstore_name = SYSTEM_VSTORE_NAME
    row_data = [vstore_id, vstore_name]
    nfs_service_des = "cmd_display_admin_nfs_service"
    update_table_data_to_row_data(context, row_data, nfs_service_des)
    update_nfs_common_conf_to_row_data(context, row_data)
    nfs_service_conf_des = "cmd_display_admin_nfs_service_config"
    update_key_value_data_to_row_data(context, row_data, nfs_service_conf_des)
    row_data.append(get_nfs_reserve_bit(context))
    data_content.append(row_data)


def build_vstore_content(context, data_content):
    # 租户
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, vstore_name in id_name_map.items():
        row_data = [vstore_id, vstore_name]
        nfs_service_des = "cmd_display_vstore_%s_nfs_service" % vstore_id
        update_table_data_to_row_data(context, row_data, nfs_service_des)
        update_nfs_common_conf_to_row_data(context, row_data)
        nfs_service_conf_des = "cmd_display_vstore_%s_nfs_service_config" % vstore_id
        update_key_value_data_to_row_data(context, row_data, nfs_service_conf_des)
        row_data.append(get_nfs_reserve_bit(context))
        data_content.append(row_data)


def update_table_data_to_row_data(context, row_data, des):
    table_type_lines = get_command_result_lines(context, des)
    table_data = parse_table_type_result(table_type_lines)
    # table只有一行
    for data in table_data:
        row_data.extend([
            data.get("Support V3 Enabled"), data.get("Support V4 Enabled"), data.get("V4 Domain Name"),
            data.get("V3 ACL Enabled"), data.get("Support V41 Enabled")
        ])


def update_key_value_data_to_row_data(context, row_data, des):
    data_dict = get_key_value_type_result(context, des, ":")
    row_data.extend([
        # 默认租户才有这个字段
        data_dict.get("Fileid Length(bit)"), data_dict.get("Extended Groups Switch"),
        data_dict.get("Extended Groups Limit"), data_dict.get("Nobody UID"),
        data_dict.get("Ignore NT ACL For Root"), data_dict.get("Global V4 Acl Preserve"),
        data_dict.get("Global Ntfs Unix Security Ops"), data_dict.get("Touch check with ACL")
    ])


def update_nfs_common_conf_to_row_data(context, row_data):
    data_dict = get_key_value_type_result(context, "cmd_display_admin_nfs_common_config", ":")
    row_data.extend([
        data_dict.get("Listen IP"), data_dict.get("Client List")
    ])


def get_nfs_reserve_bit(context):
    data_dict = get_key_value_type_result(context, "cmd_display_admin_nfs_reserve_bit", ":")
    return data_dict.get("Reservebit Value")
