#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import copy
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 NFS共享信息
    :param context: 上下文数据
    """
    data_header = [
        # nfs share
        "Vstore ID", "Vstore", "Share ID", "Filesystem ID", "Local Path", "Alias", "CharSet", "Lock Type",
        "Audit Items", "show_snapshot_enabled", "Share Description",
        # nfs share_permission
        "Share Permission ID", "Access Name",
        "Access Type", "Sync Enabled", "All Squash Enabled", "Root Squash Enabled", "Secure Enabled",
        "Share Permission Charset", "Anonymous User ID", "V4 Acl Preserve", "Ntfs Unix Security Ops"
    ]
    parse_data(context, [data_header], get_nfs_share_content)


def get_nfs_share_content(context):
    nfs_share_content_dic = {}
    # 将默认租户下nfs_share字段装入字典
    build_admin_content_dic(context, nfs_share_content_dic)
    # 将租户下nfs_share字段装入字典
    build_vstore_content_dic(context, nfs_share_content_dic)
    data_content = []
    share_permission_content_dic = build_nfs_share_id_share_permissions_mapping(context)
    for key, share_content in nfs_share_content_dic.items():
        if key in share_permission_content_dic.keys():
            share_permission_contents = share_permission_content_dic.get(key)
            build_data_content_each_row_data(share_content, share_permission_contents, data_content)
        else:
            share_permission_contents = share_permission_content_dic.get("--")
            build_data_content_each_row_data(share_content, share_permission_contents, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_admin_content_dic(context, content_dic):
    # admin
    vstore_id = SYSTEM_VSTORE_ID
    vstore_name = SYSTEM_VSTORE_NAME
    admin_nfs_share_table_lines = get_command_result_lines(context, "cmd_display_admin_nfs_share")
    table_data = parse_table_type_result(admin_nfs_share_table_lines)
    for data in table_data:
        share_id = data["Share ID"]
        admin_nfs_share_des = "cmd_display_admin_nfs_share_id_%s" % share_id
        data_dict = get_key_value_type_result(context, admin_nfs_share_des, ":")
        build_content_dic(content_dic, data_dict, share_id, vstore_id, vstore_name)


def build_vstore_content_dic(context, content_dic):
    # 租户
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, vstore_name in id_name_map.items():
        vstore_nfs_share_table_lines = get_command_result_lines(context, "cmd_display_vstore_%s_nfs_share" % vstore_id)
        table_data = parse_table_type_result(vstore_nfs_share_table_lines)
        for data in table_data:
            share_id = data["Share ID"]
            vstore_nfs_share_des = "cmd_display_vstore_%s_nfs_share_id_%s" % (vstore_id, share_id)
            data_dict = get_key_value_type_result(context, vstore_nfs_share_des, ":")
            build_content_dic(content_dic, data_dict, share_id, vstore_id, vstore_name)


def build_content_dic(content_dic, data_dict, share_id, vstore_id, vstore_name):
    row_data = [vstore_id, vstore_name, share_id, data_dict.get("File System ID"),
                data_dict.get("Local Path"), data_dict.get("Alias"), data_dict.get("CharSet"),
                data_dict.get("Lock Type"), data_dict.get("Audit Items"), data_dict.get("show_snapshot_enabled"),
                data_dict.get("Description"), ]
    content_dic[(vstore_id + share_id)] = row_data


def build_nfs_share_id_share_permissions_mapping(context):
    """
    构建nfs_share_id下对应的share_permission映射
    :param context: 上下文
    :return: nfs_share_id下对应的share_permission映射字典
    """
    nfs_share_permission_content_dic = {}
    # admin(默认租户)
    admin_des = "cmd_display_admin_nfs_share_permission"
    admin_permission_lines = get_command_result_lines(context, admin_des)
    admin_permission_table_data = parse_table_type_result(admin_permission_lines)
    for data in admin_permission_table_data:
        permission_id = data.get("Share Permission ID")
        admin_nfs_share_permission_des = "cmd_display_admin_nfs_share_permission_id_%s" % permission_id
        data_dict = get_key_value_type_result(context, admin_nfs_share_permission_des, ":")
        update_nfs_share_permission_content_dic(SYSTEM_VSTORE_ID, nfs_share_permission_content_dic, data_dict)
    # vstore(其它租户)
    vstore_id_name_mapping = get_vstore_id_name_mapping(context)
    for vstore_id in vstore_id_name_mapping.keys():
        vstore_des = "cmd_display_vstore_%s_nfs_share_permission" % vstore_id
        vstore_permission_lines = get_command_result_lines(context, vstore_des)
        vstore_permission_table_data = parse_table_type_result(vstore_permission_lines)
        for data in vstore_permission_table_data:
            permission_id = data.get("Share Permission ID")
            vstore_nfs_share_permission_des = "cmd_display_vstore_%s_nfs_share_permission_id_%s" % (
                vstore_id, permission_id)
            data_dict = get_key_value_type_result(context, vstore_nfs_share_permission_des, ":")
            update_nfs_share_permission_content_dic(vstore_id, nfs_share_permission_content_dic, data_dict)
    # 占位,当租户的某个share_id不存在share_permission时，返回空
    nfs_share_permission_content_dic["--"] = [["", "", "", "", "", "", "", "", "", "", ""]]
    return nfs_share_permission_content_dic


def update_nfs_share_permission_content_dic(vstore_id, nfs_share_permission_content_dic, data_dict):
    row_data = [data_dict.get("Share Permission ID"), data_dict.get("Access Name"), data_dict.get("Access Type"),
                data_dict.get("Sync Enabled"), data_dict.get("All Squash Enabled"),
                data_dict.get("Root Squash Enabled"), data_dict.get("Secure Enabled"),
                data_dict.get("Charset"), data_dict.get("Anonymous User ID"), data_dict.get("V4 Acl Preserve"),
                data_dict.get("Ntfs Unix Security Ops")]
    key = vstore_id + data_dict.get("Share ID").strip()
    share_permission_content = nfs_share_permission_content_dic.get(key, [])
    share_permission_content.append(row_data)
    nfs_share_permission_content_dic[key] = share_permission_content


def build_data_content_each_row_data(share_content, share_permission_contents, data_content):
    # 这里应该深拷贝
    for content in share_permission_contents:
        new_nfs_share_content = copy.deepcopy(share_content)
        new_nfs_share_content.extend(content)
        data_content.append(new_nfs_share_content)
