#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取V3/V5 系统总览信息
    :param context: 上下文数据
    """
    data_header = [
        "System Name", "Type", "Vendor", "Model",
        "IP", "Product Model", "Version", "Patch Version",
        "Health Status", "Running Status", "Total Capacity", "SN"
    ]
    parse_data(context, [data_header], get_overview_content)


def get_overview_content(context):
    dev_type = context.get("dev_type")
    dev_vendor = context.get("dev_vendor")
    dev_model = context.get("dev_model")
    dev_ip = context.get("ip")
    system_data_dict = get_key_value_type_result(context, "cmd_display_admin_system", ":", False)
    row_data = [system_data_dict.get("System Name"), dev_type, dev_vendor, dev_model, dev_ip,
                system_data_dict.get("Product Model"), system_data_dict.get("Product Version"),
                system_data_dict.get("Patch Version"), system_data_dict.get("Health Status"),
                system_data_dict.get("Running Status"), system_data_dict.get("Total Capacity"),
                system_data_dict.get("SN")]
    return [row_data]
