#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, \
    get_file_system_id_vstore_id_mapping, get_file_system_id_name_mapping, vstore_id_to_sort
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_NAME
from storages.HUAWEI.huawei_storage_util import parse_table_type_result


def execute(context):
    """
    获取V3/V5 文件系统quota信息
    :param context: 上下文数据
    """
    data_header = ["Vstore ID", "Vstore", "Filesystem ID", "Filesystem Name", "Quota ID", "Quota Tree Name",
                   "Quota Type", "User/Group Name", "User/Group Type", "Space Soft Quota", "Space Hard Quota",
                   "File Soft Quota", "File Hard Quota", "Space Used", "File Used", "Space Used Rate(%)",
                   "File Used Rate(%)"]
    parse_data(context, [data_header], get_quota_file_system_content)


def get_quota_file_system_content(context):
    data_content = []
    file_sys_id_vstore_id_map = get_file_system_id_vstore_id_mapping(context)
    id_name_map = get_vstore_id_name_mapping(context)
    file_sys_id_name_map = get_file_system_id_name_mapping(context)
    for file_sys_id, vstore_id in file_sys_id_vstore_id_map.items():
        # id_name_map没有默认租户"--"的映射，默认租户返回"System Vstore"
        vstore_name = id_name_map.get(vstore_id, SYSTEM_VSTORE_NAME)
        quota_des = "cmd_display_vstore_%s_quota_file_system_id=%s"
        quota_table_lines = get_command_result_lines(context, quota_des % (vstore_id, file_sys_id))
        table_data = parse_table_type_result(quota_table_lines)
        for data in table_data:
            row_data = [vstore_id, vstore_name, file_sys_id, file_sys_id_name_map.get(file_sys_id),
                        data.get("Quota ID"), data.get("Quota Tree Name"), data.get("Quota Type"),
                        data.get("User/Group Name"), data.get("User/Group Type"), data.get("Space Soft Quota"),
                        data.get("Space Hard Quota"), data.get("File Soft Quota"), data.get("File Hard Quota"),
                        data.get("Space Used"), data.get("File Used"), data.get("Space Used Rate(%)"),
                        data.get("File Used Rate(%)")]
            data_content.append(row_data)
    data_content.sort(key=vstore_id_to_sort)
    return data_content
