#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取V3/V5 远程复制信息
    :param context: 上下文数据
    """
    data_header = [
        # 第一条
        "Remote Replication ID(s)", "Health Status", "Running Status", "Is Primary", "Local Resource Name",
        "Remote Device SN", "Remote Device Name", "Remote Resource Name", "Synchronization Type",
        "Recovery Policy", "Replication Mode", "Rate", "Timing Length",
        # 第二条
        "Vstore Pair ID", "Local Vstore Name", "Remote Vstore Name"
    ]
    parse_data(context, [data_header], get_remote_replication_content)


def get_remote_replication_content(context):
    data_content = []
    remote_replication_table_lines = get_command_result_lines(context, "cmd_display_admin_remote_replication_unified")
    table_data = parse_table_type_result(remote_replication_table_lines)
    pair_id_info_map = get_vstore_pair_id_info_mapping(context)
    for data in table_data:
        remote_replication_id = data.get("ID")
        des = "cmd_display_admin_remote_replication_unified_replication_id_%s" % remote_replication_id
        data_dict = get_key_value_type_result(context, des, ":", False)
        row_data = [remote_replication_id, data_dict.get("Health Status"), data_dict.get("Running Status"),
                    data_dict.get("Is Primary"), data_dict.get("Local Resource Name"),
                    data_dict.get("Remote Device SN"), data_dict.get("Remote Device Name"),
                    data_dict.get("Remote Resource Name"), data_dict.get("Synchronization Type"),
                    data_dict.get("Recovery Policy"), data_dict.get("Replication Mode"), data_dict.get("Rate"),
                    data_dict.get("Timing Length"), data_dict.get("Vstore Pair ID")]
        vstore_pair_id = data_dict.get("Vstore Pair ID")
        vstore_name_info = pair_id_info_map.get(vstore_pair_id)
        if not vstore_name_info:
            vstore_name_info = pair_id_info_map.get("--")
        row_data.extend(vstore_name_info)
        data_content.append(row_data)
    return data_content


def get_vstore_pair_id_info_mapping(context):
    des = "cmd_display_admin_remote_replication_vstore_general"
    remote_replication_table_lines = get_command_result_lines(context, des)
    table_data = parse_table_type_result(remote_replication_table_lines)
    pair_id_info_dict = {}
    for data in table_data:
        vstore_pair_id = data.get("ID")
        des = "cmd_display_admin_remote_replication_vstore_vstore_pair_%s" % vstore_pair_id
        data_dict = get_key_value_type_result(context, des, ":")
        pair_id_info_dict[vstore_pair_id] = [data_dict.get("Local Vstore Name"), data_dict.get("Remote Vstore Name")]
    pair_id_info_dict["--"] = ["", ""]
    return pair_id_info_dict
