#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, \
    get_file_system_id_vstore_id_mapping, get_file_system_id_name_mapping, vstore_id_to_sort, get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 快照信息信息
    :param context: 上下文数据
    """
    data_header = [
        "Vstore ID", "Vstore", "Filesystem ID", "Filesystem Name", "Schedule ID", "Schedule Name", "Type",
        "Week Start Time", "Week Days", "Hour", "Minute", "Month Day", "Month Start Time", "Frequency Time",
        "Frequency Snapshot Max Number", "Daily Snapshot Max Number", "Weekly Snapshot Max Number",
        "Monthly Snapshot Max Number",
    ]
    parse_data(context, [data_header], get_snapshot_content)


def get_snapshot_content(context):
    data_content = []
    file_sys_id_vstore_id_map = get_file_system_id_vstore_id_mapping(context)
    file_sys_id_name_map = get_file_system_id_name_mapping(context)
    id_name_map = get_vstore_id_name_mapping(context)
    snapshot_table_lines = get_command_result_lines(context, "cmd_display_all_fs_snapshot_schedule")
    table_data = parse_table_type_result(snapshot_table_lines)
    for data in table_data:
        file_sys_id = data.get("File System ID")
        file_sys_name = file_sys_id_name_map.get(file_sys_id)
        vstore_id = file_sys_id_vstore_id_map.get(file_sys_id)
        # id_name_map没有默认租户"--"的映射，默认租户返回"System Vstore"
        vstore_name = id_name_map.get(vstore_id, SYSTEM_VSTORE_NAME)
        schedule_id = data.get("ID")
        des = "cmd_display_each_fs_snapshot_schedule_schedule_id_%s" % schedule_id
        data_dict = get_key_value_type_result(context, des, ":", False)
        row_data = [
            vstore_id, vstore_name, file_sys_id, file_sys_name, schedule_id, data_dict.get("Name"),
            data_dict.get("Type"), data_dict.get("Week Start Time"), data_dict.get("Week Days"), data_dict.get("Hour"),
            data_dict.get("Minute"), data_dict.get("Month Day"), data_dict.get("Month Start Time"),
            data_dict.get("Frequency Time"), data_dict.get("Frequency Snapshot Max Number"),
            data_dict.get("Daily Snapshot Max Number"), data_dict.get("Weekly Snapshot Max Number"),
            data_dict.get("Monthly Snapshot Max Number"),
        ]
        data_content.append(row_data)
    data_content.sort(key=vstore_id_to_sort)
    return data_content
