#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.huawei_storage_util import parse_table_type_result
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 用户映射信息
    :param context: 上下文数据
    """
    data_header = [
        "Vstore ID", "Vstore", "From Identity", "To Identity", "Mapping Type",
        "Priority", "Host Name", "Address", "Provider", "IDMU Base DN", "IDMU Timeout(s)",
        "IDMU Windows Objectclass", "IDMU Unix Objectclass", "WTOU Samename Mapping", "UTOW Sensitive",
        "Default Windows User", "Default UNIX User",
    ]
    parse_data(context, [data_header], get_user_mapping_content)


def get_user_mapping_content(context):
    data_content = []
    build_admin_content(context, data_content)
    build_vstore_content(context, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_admin_content(context, data_content):
    # admin
    vstore_id = SYSTEM_VSTORE_ID
    vstore_name = SYSTEM_VSTORE_NAME
    table_type_lines = get_command_result_lines(context, "cmd_display_admin_identity_mapping_rule")
    table_data = parse_table_type_result(table_type_lines)
    if not table_data:
        row_data = [vstore_id, vstore_name, "", "", "", "", "", ""]
        update_row_data(context, row_data, vstore_id)
        data_content.append(row_data)
    for data in table_data:
        row_data = [vstore_id, vstore_name]
        row_data.extend([
            data.get("From Identity"),
            data.get("To Identity"),
            data.get("Mapping Type"),
            data.get("Priority"),
            data.get("Host Name"),
            data.get("Address")
        ])
        update_row_data(context, row_data)
        data_content.append(row_data)


def build_vstore_content(context, data_content):
    # 租户
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, vstore_name in id_name_map.items():
        table_type_lines = get_command_result_lines(context, "cmd_display_vstore_%s_identity_mapping_rule" % vstore_id)
        table_data = parse_table_type_result(table_type_lines)
        if not table_data:
            row_data = [vstore_id, vstore_name, "", "", "", "", "", ""]
            update_row_data(context, row_data, vstore_id)
            data_content.append(row_data)
            continue
        for data in table_data:
            row_data = [vstore_id, vstore_name]
            row_data.extend([
                data.get("From Identity"),
                data.get("To Identity"),
                data.get("Mapping Type"),
                data.get("Priority"),
                data.get("Host Name"),
                data.get("Address")
            ])
            update_row_data(context, row_data, vstore_id)
            data_content.append(row_data)


def update_row_data(context, row_data, vstore_id=None):
    # vstore Config + nfs + cifs
    if vstore_id:
        identity_mapping_des = "cmd_display_vstore_%s_identity_mapping_config" % vstore_id
        update_identity_mapping_config_to_row_data(context, row_data, identity_mapping_des)
        nfs_conf_des = "cmd_display_vstore_%s_nfs_service_config" % vstore_id
        update_windows_user_to_row_data(context, row_data, nfs_conf_des)
        cifs_conf_des = "cmd_display_vstore_%s_cifs_service_config" % vstore_id
        update_unix_user_to_row_data(context, row_data, cifs_conf_des)
    # admin Config + nfs + cifs
    else:
        des = "cmd_display_admin_identity_mapping_config"
        update_identity_mapping_config_to_row_data(context, row_data, des)
        nfs_conf_des = "cmd_display_admin_nfs_service_config"
        update_windows_user_to_row_data(context, row_data, nfs_conf_des)
        cifs_conf_des = "cmd_display_admin_cifs_service_config"
        update_unix_user_to_row_data(context, row_data, cifs_conf_des)


def update_identity_mapping_config_to_row_data(context, row_data, des):
    data_dict = get_key_value_type_result(context, des, ":")
    row_data.extend([
        data_dict.get("Provider"),
        data_dict.get("IDMU Base DN"),
        data_dict.get("IDMU Timeout(s)"),
        data_dict.get("IDMU Windows Objectclass"),
        data_dict.get("IDMU Unix Objectclass"),
        data_dict.get("WTOU Samename Mapping"),
        data_dict.get("UTOW Sensitive")
    ])


def update_windows_user_to_row_data(context, row_data, des):
    data_dict = get_key_value_type_result(context, des, ":")
    row_data.append(data_dict.get("Default Windows User"))


def update_unix_user_to_row_data(context, row_data, des):
    data_dict = get_key_value_type_result(context, des, ":")
    row_data.append(data_dict.get("Default UNIX User"))
