#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.storage_common import get_command_result_lines, SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.HUAWEI.huawei_storage_util import parse_table_type_result


def execute(context):
    """
    获取V3/V5 本地用户信息
    :param context: 上下文数据
    """
    data_header = ["Vstore ID", "Vstore", "User ID", "User Name", "Primary Group Name", "Secondary Group Names",
                   "Group Names", "User Type", "Status Enabled", "Passwd Expired Time(Days)", "Description",
                   "SID Prefix", "SID Suffix", "Type"]
    parse_data(context, [data_header], get_user_content)


def get_user_content(context):
    data_content = []
    build_admin_content(context, data_content)
    build_vstore_content(context, data_content)
    data_content.sort(key=vstore_id_to_sort)
    return data_content


def build_admin_content(context, data_content):
    # admin
    vstore_id = SYSTEM_VSTORE_ID
    vstore = SYSTEM_VSTORE_NAME
    user_table_lines = get_command_result_lines(context, "cmd_display_admin_resource_user")
    table_data = parse_table_type_result(user_table_lines)
    for data in table_data:
        user_id = data.get("User ID")
        des = "cmd_display_admin_resource_user_user_id_%s" % user_id
        data_dict = get_key_value_type_result(context, des, ":")
        row_data = [vstore_id, vstore, user_id]
        build_row_of_data_content(row_data, data_dict, user_id)
        data_content.append(row_data)


def build_vstore_content(context, data_content):
    # 租户
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id, vstore_name in id_name_map.items():
        user_table_lines = get_command_result_lines(context, "cmd_display_vstore_%s_resource_user" % vstore_id)
        table_data = parse_table_type_result(user_table_lines)
        for data in table_data:
            user_id = data.get("User ID")
            des = "cmd_display_vstore_%s_resource_user_user_id_%s" % (vstore_id, user_id)
            data_dict = get_key_value_type_result(context, des, ":")
            row_data = [vstore_id, vstore_name, user_id]
            build_row_of_data_content(row_data, data_dict, user_id)
            data_content.append(row_data)


def build_row_of_data_content(row_data, data_dict, user_id):
    group_names = data_dict.get("Primary Group Name")
    if data_dict.get("Secondary Group Names").strip():
        group_names = data_dict.get("Primary Group Name") + "," + data_dict.get("Secondary Group Names")
    sid_suffix = str(float(user_id) + 1000).split(".")[0]
    row_data.extend([
        data_dict.get("User Name"), data_dict.get("Primary Group Name"),
        data_dict.get("Secondary Group Names"), group_names, data_dict.get("User Type"),
        data_dict.get("Status Enabled"), data_dict.get("Passwd Expired Time(Days)"), data_dict.get("Description"),
        "S-1-6-88", sid_suffix, "All"
    ])
