#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import get_vstore_id_name_mapping, parse_data, vstore_id_to_sort, \
    get_key_value_type_result
from storages.storage_common import SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME


def execute(context):
    """
    获取V3/V5 租户信息
    :param context: 上下文数据
    """
    data_header = ["Vstore ID", "Vstore", "Running Status", "Description", "SAN Capacity Quota",
                   "SAN Free Capacity Quota",
                   "NAS Capacity Quota", "NAS Free Capacity Quota", "SAN Total Capacity", "NAS Total Capacity"]
    parse_data(context, [data_header], get_vstore_content)


def get_vstore_content(context):
    data_content = []
    # 添加默认租户
    data_content.append([SYSTEM_VSTORE_ID, SYSTEM_VSTORE_NAME, "", "", "", "", "", "", "", ""])
    # 添加租户
    id_name_map = get_vstore_id_name_mapping(context)
    for vstore_id in id_name_map.keys():
        data_dict = get_key_value_type_result(context, "cmd_display_admin_vstore_%s_details" % vstore_id, ":")
        vstore_id = data_dict.get("ID")
        vstore_name = data_dict.get("Name")
        running_status = data_dict.get("Running Status")
        description = data_dict.get("Description")
        san_capacity_quota = data_dict.get("SAN Capacity Quota")
        san_free_capacity_quota = data_dict.get("SAN Free Capacity Quota")
        nas_capacity_quota = data_dict.get("NAS Capacity Quota")
        nas_free_capacity_quota = data_dict.get("NAS Free Capacity Quota")
        san_total_capacity = data_dict.get("SAN Total Capacity")
        nas_total_capacity = data_dict.get("NAS Total Capacity")
        row_data = [vstore_id, vstore_name, running_status, description, san_capacity_quota, san_free_capacity_quota,
                    nas_capacity_quota, nas_free_capacity_quota, san_total_capacity, nas_total_capacity]
        data_content.append(row_data)
    data_content.sort(key=vstore_id_to_sort)
    return data_content
